/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.shapes;

import com.google.common.collect.Sets;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.shapes.IShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class Line
implements IShape {
    Coord start;
    Coord end;

    public Line(Coord start, Coord end) {
        this.start = start.copy();
        this.end = end.copy();
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> coords = new ArrayList<Coord>();
        for (Coord c : this) {
            coords.add(c);
        }
        return coords;
    }

    @Override
    public Set<Coord> getAnchors() {
        return Sets.newHashSet((Object[])new Coord[]{this.start, this.end});
    }

    @Override
    @Nonnull
    public Iterator<Coord> iterator() {
        return new LineIterator();
    }

    private class LineIterator
    implements Iterator<Coord> {
        int x;
        int y;
        int z;
        int dx;
        int dy;
        int dz;
        int l;
        int m;
        int n;
        int x_inc;
        int y_inc;
        int z_inc;
        int err_1;
        int err_2;
        int dx2;
        int dy2;
        int dz2;
        int i;

        public LineIterator() {
            Coord point = Line.this.start.copy();
            this.x = point.getX();
            this.y = point.getY();
            this.z = point.getZ();
            this.dx = Line.this.end.getX() - Line.this.start.getX();
            this.dy = Line.this.end.getY() - Line.this.start.getY();
            this.dz = Line.this.end.getZ() - Line.this.start.getZ();
            this.x_inc = this.dx < 0 ? -1 : 1;
            this.l = Math.abs(this.dx);
            this.y_inc = this.dy < 0 ? -1 : 1;
            this.m = Math.abs(this.dy);
            this.z_inc = this.dz < 0 ? -1 : 1;
            this.n = Math.abs(this.dz);
            this.dx2 = this.l << 1;
            this.dy2 = this.m << 1;
            this.dz2 = this.n << 1;
            this.i = 0;
            if (this.l >= this.m && this.l >= this.n) {
                this.err_1 = this.dy2 - this.l;
                this.err_2 = this.dz2 - this.l;
            } else if (this.m >= this.l && this.m >= this.n) {
                this.err_1 = this.dx2 - this.m;
                this.err_2 = this.dz2 - this.m;
            } else {
                this.err_1 = this.dy2 - this.n;
                this.err_2 = this.dz2 - this.n;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.l >= this.m && this.l >= this.n) {
                return this.i < this.l;
            }
            if (this.m >= this.l && this.m >= this.n) {
                return this.i < this.m;
            }
            return this.i < this.n;
        }

        @Override
        public Coord next() {
            if (this.l >= this.m && this.l >= this.n) {
                if (this.err_1 > 0) {
                    this.y += this.y_inc;
                    this.err_1 -= this.dx2;
                }
                if (this.err_2 > 0) {
                    this.z += this.z_inc;
                    this.err_2 -= this.dx2;
                }
                this.err_1 += this.dy2;
                this.err_2 += this.dz2;
                this.x += this.x_inc;
            } else if (this.m >= this.l && this.m >= this.n) {
                if (this.err_1 > 0) {
                    this.x += this.x_inc;
                    this.err_1 -= this.dy2;
                }
                if (this.err_2 > 0) {
                    this.z += this.z_inc;
                    this.err_2 -= this.dy2;
                }
                this.err_1 += this.dx2;
                this.err_2 += this.dz2;
                this.y += this.y_inc;
            } else {
                if (this.err_1 > 0) {
                    this.y += this.y_inc;
                    this.err_1 -= this.dz2;
                }
                if (this.err_2 > 0) {
                    this.x += this.x_inc;
                    this.err_2 -= this.dz2;
                }
                this.err_1 += this.dy2;
                this.err_2 += this.dx2;
                this.z += this.z_inc;
            }
            ++this.i;
            return new Coord(this.x, this.y, this.z);
        }
    }
}

