/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.shapes;

import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.List;
import java.util.Set;

public interface IShape
extends Iterable<Coord> {
    default public IShape fill(WorldEditor editor, BlockBrush block) {
        return this.fill(editor, block, true, true);
    }

    default public IShape fill(WorldEditor editor, BlockBrush block, boolean fillAir, boolean replaceSolid) {
        for (Coord coord : this) {
            block.stroke(editor, coord, fillAir, replaceSolid);
        }
        return this;
    }

    public List<Coord> get();

    public Set<Coord> getAnchors();

    default public IShape translate(Direction direction, int amount) {
        this.getAnchors().forEach(coord -> coord.translate(direction, amount));
        return this;
    }
}

