/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBounded;
import greymerk.roguelike.worldgen.shapes.IShape;
import greymerk.roguelike.worldgen.shapes.Shape;

public class BoundingBox
implements IBounded {
    private Coord start;
    private Coord end;

    public BoundingBox(Coord start, Coord end) {
        this.start = start.copy();
        this.end = end.copy();
        Coord.correct(this.start, this.end);
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this;
    }

    @Override
    public boolean collide(IBounded other) {
        BoundingBox otherBox = other.getBoundingBox();
        if (this.end.getX() < otherBox.start.getX() || otherBox.end.getX() < this.start.getX()) {
            return false;
        }
        if (this.end.getY() < otherBox.start.getY() || otherBox.end.getY() < this.start.getY()) {
            return false;
        }
        return this.end.getZ() >= otherBox.start.getZ() && otherBox.end.getZ() >= this.start.getZ();
    }

    @Override
    public IShape getShape(Shape type) {
        return Shape.get(type, this.start, this.end);
    }

    @Override
    public Coord getStart() {
        return this.start.copy();
    }

    @Override
    public Coord getEnd() {
        return this.end.copy();
    }
}

