/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.BlockProvider;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.ArrayList;

public class BlockCheckers
implements BlockBrush {
    private final BlockBrush fillOne;
    private final BlockBrush fillTwo;
    private Coord offset;

    public BlockCheckers(BlockBrush fillOne, BlockBrush fillTwo, Coord offset) {
        this.fillOne = fillOne;
        this.fillTwo = fillTwo;
        this.offset = offset.copy();
    }

    public BlockCheckers(BlockBrush fillOne, BlockBrush fillTwo) {
        this(fillOne, fillTwo, new Coord(0, 0, 0));
    }

    public BlockCheckers(JsonElement json) {
        JsonArray arr = (JsonArray)json;
        ArrayList<BlockBrush> blocks = new ArrayList<BlockBrush>();
        for (JsonElement jsonElement : arr) {
            if (jsonElement.isJsonNull()) continue;
            blocks.add(BlockProvider.create(jsonElement.getAsJsonObject()));
        }
        this.fillOne = (BlockBrush)blocks.get(0);
        this.fillTwo = (BlockBrush)blocks.get(1);
    }

    @Override
    public boolean stroke(WorldEditor editor, Coord origin, boolean fillAir, boolean replaceSolid) {
        int x = origin.getX() - this.offset.getX();
        int y = origin.getY() - this.offset.getY();
        int z = origin.getZ() - this.offset.getY();
        if (x % 2 == 0) {
            if (z % 2 == 0) {
                if (y % 2 == 0) {
                    return this.fillOne.stroke(editor, origin.copy(), fillAir, replaceSolid);
                }
                return this.fillTwo.stroke(editor, origin.copy(), fillAir, replaceSolid);
            }
            if (y % 2 == 0) {
                return this.fillTwo.stroke(editor, origin.copy(), fillAir, replaceSolid);
            }
            return this.fillOne.stroke(editor, origin.copy(), fillAir, replaceSolid);
        }
        if (z % 2 == 0) {
            if (y % 2 == 0) {
                return this.fillTwo.stroke(editor, origin.copy(), fillAir, replaceSolid);
            }
            return this.fillOne.stroke(editor, origin.copy(), fillAir, replaceSolid);
        }
        if (y % 2 == 0) {
            return this.fillOne.stroke(editor, origin.copy(), fillAir, replaceSolid);
        }
        return this.fillTwo.stroke(editor, origin.copy(), fillAir, replaceSolid);
    }
}

