/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import com.google.gson.JsonObject;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemBase;
import greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemWeapon
extends ItemBase {
    private Equipment type;
    private boolean enchant;
    private Quality quality;

    public ItemWeapon(int weight, int level) {
        super(weight, level);
    }

    public ItemWeapon(JsonObject data, int weight) throws Exception {
        super(weight);
        boolean bl = this.enchant = !data.has("ench") || data.get("ench").getAsBoolean();
        if (data.has("quality")) {
            try {
                this.quality = Quality.valueOf(data.get("quality").getAsString().toUpperCase());
            }
            catch (Exception e) {
                throw new Exception("No such Quality as: " + data.get("quality").getAsString());
            }
        }
        if (data.has("equipment")) {
            try {
                this.type = Equipment.valueOf(data.get("equipment").getAsString().toUpperCase());
            }
            catch (Exception e) {
                throw new Exception("No such Equipment as: " + data.get("equipment").getAsString());
            }
        }
        if (!data.has("level")) {
            throw new Exception("Weapon Loot requires a level");
        }
        this.level = data.get("level").getAsInt();
    }

    public static ItemStack getRandom(Random rand, int rank, boolean enchant) {
        if (rand.nextInt(10) == 0) {
            return ItemWeapon.getBow(rand, rank, enchant);
        }
        return ItemWeapon.getSword(rand, rank, enchant);
    }

    public static ItemStack getBow(Random rand, int level, boolean enchant) {
        if (rand.nextInt(20 + level * 10) == 0) {
            return ItemSpecialty.getRandomItem(Equipment.BOW, rand, level);
        }
        ItemStack bow = new ItemStack((Item)Items.field_151031_f);
        if (enchant && rand.nextInt(6 - level) == 0) {
            Enchant.enchantItem(rand, bow, Enchant.getLevel(rand, level));
        }
        return bow;
    }

    public static ItemStack getSword(Random rand, int level, boolean enchant) {
        if (enchant && rand.nextInt(10 + level * 10) == 0) {
            return ItemSpecialty.getRandomItem(Equipment.SWORD, rand, level);
        }
        ItemStack sword = ItemWeapon.pickSword(rand, level);
        if (enchant && rand.nextInt(6 - level) == 0) {
            Enchant.enchantItem(rand, sword, Enchant.getLevel(rand, level));
        }
        return sword;
    }

    public static ItemStack getSword(Random rand, int level, boolean enchant, Quality quality) {
        ItemStack sword = quality != null ? ItemWeapon.getSwordByQuality(quality) : ItemWeapon.pickSword(rand, level);
        return enchant ? Enchant.enchantItem(rand, sword, Enchant.getLevel(rand, level)) : sword;
    }

    private static ItemStack pickSword(Random rand, int level) {
        Quality quality = Quality.getWeaponQuality(rand, level);
        return ItemWeapon.getSwordByQuality(quality);
    }

    private static ItemStack getSwordByQuality(Quality quality) {
        switch (quality) {
            case DIAMOND: {
                return new ItemStack(Items.field_151048_u);
            }
            case GOLD: {
                return new ItemStack(Items.field_151010_B);
            }
            case IRON: {
                return new ItemStack(Items.field_151040_l);
            }
            case STONE: {
                return new ItemStack(Items.field_151052_q);
            }
        }
        return new ItemStack(Items.field_151041_m);
    }

    @Override
    public ItemStack getLootItem(Random rand, int level) {
        if (this.type != null) {
            switch (this.type) {
                case BOW: {
                    return ItemWeapon.getBow(rand, level, this.enchant);
                }
                case SWORD: {
                    return ItemWeapon.getSword(rand, level, this.enchant, this.quality);
                }
            }
            return ItemWeapon.getSword(rand, level, this.enchant);
        }
        return ItemWeapon.getRandom(rand, level, true);
    }
}

