/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import com.github.srwaggon.util.Color;
import com.google.gson.JsonObject;
import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.Slot;
import greymerk.roguelike.treasure.loot.provider.ItemBase;
import greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemArmour
extends ItemBase {
    private Equipment equipment;
    private boolean enchant;
    private Quality quality;

    public ItemArmour(int weight, int level) {
        super(weight, level);
    }

    public ItemArmour(JsonObject data, int weight) throws Exception {
        super(weight);
        boolean bl = this.enchant = !data.has("ench") || data.get("ench").getAsBoolean();
        if (!data.has("level")) {
            throw new Exception("Armour requires a level");
        }
        this.level = data.get("level").getAsInt();
        if (data.has("equipment")) {
            try {
                this.equipment = Equipment.valueOf(data.get("equipment").getAsString().toUpperCase());
            }
            catch (Exception e) {
                throw new Exception("No such Equipment as: " + data.get("equipment").getAsString());
            }
        }
        if (data.has("quality")) {
            this.level = data.get("level").getAsInt();
            try {
                this.quality = Quality.valueOf(data.get("quality").getAsString().toUpperCase());
            }
            catch (Exception e) {
                throw new Exception("No such Quality as: " + data.get("quality").getAsString());
            }
        }
    }

    public static ItemStack get(Random rand, int level, Quality quality, Equipment armorEquipment, boolean enchant) {
        ItemStack armorItem = armorEquipment.get(quality == null ? Quality.get(level) : quality);
        return enchant ? Enchant.enchantItem(rand, armorItem, Enchant.getLevel(rand, level)) : armorItem;
    }

    public static ItemStack getRandom(Random rand, int level, boolean enchant) {
        return ItemArmour.getRandom(rand, level, Slot.getSlotByNumber(rand.nextInt(4) + 1), enchant ? Enchant.getLevel(rand, level) : 0);
    }

    public static ItemStack getRandom(Random rand, int level, Slot slot, boolean enchant) {
        return ItemArmour.getRandom(rand, level, slot, enchant ? Enchant.getLevel(rand, level) : 0);
    }

    public static ItemStack getRandom(Random rand, int level, Slot slot, int enchantLevel) {
        if (enchantLevel > 0 && rand.nextInt(20 + level * 10) == 0) {
            switch (slot) {
                case HEAD: {
                    return ItemSpecialty.getRandomItem(Equipment.HELMET, rand, level);
                }
                case CHEST: {
                    return ItemSpecialty.getRandomItem(Equipment.CHEST, rand, level);
                }
                case LEGS: {
                    return ItemSpecialty.getRandomItem(Equipment.LEGS, rand, level);
                }
                case FEET: {
                    return ItemSpecialty.getRandomItem(Equipment.FEET, rand, level);
                }
            }
        }
        ItemStack item = ItemArmour.get(slot, Quality.getArmourQuality(rand, level));
        ItemArmour.dyeArmor(item, Color.random(rand));
        if (enchantLevel > 0) {
            Enchant.enchantItem(rand, item, enchantLevel);
        }
        return item;
    }

    public static ItemStack get(Slot slot, Quality quality) {
        switch (slot) {
            case HEAD: {
                switch (quality) {
                    case DIAMOND: {
                        return new ItemStack((Item)Items.field_151161_ac);
                    }
                    case GOLD: {
                        return new ItemStack((Item)Items.field_151169_ag);
                    }
                    case IRON: {
                        return new ItemStack((Item)Items.field_151028_Y);
                    }
                    case STONE: {
                        return new ItemStack((Item)Items.field_151020_U);
                    }
                }
                return new ItemStack((Item)Items.field_151024_Q);
            }
            case FEET: {
                switch (quality) {
                    case DIAMOND: {
                        return new ItemStack((Item)Items.field_151175_af);
                    }
                    case GOLD: {
                        return new ItemStack((Item)Items.field_151151_aj);
                    }
                    case IRON: {
                        return new ItemStack((Item)Items.field_151167_ab);
                    }
                    case STONE: {
                        return new ItemStack((Item)Items.field_151029_X);
                    }
                }
                return new ItemStack((Item)Items.field_151021_T);
            }
            case CHEST: {
                switch (quality) {
                    case DIAMOND: {
                        return new ItemStack((Item)Items.field_151163_ad);
                    }
                    case GOLD: {
                        return new ItemStack((Item)Items.field_151171_ah);
                    }
                    case IRON: {
                        return new ItemStack((Item)Items.field_151030_Z);
                    }
                    case STONE: {
                        return new ItemStack((Item)Items.field_151023_V);
                    }
                }
                return new ItemStack((Item)Items.field_151027_R);
            }
            case LEGS: {
                switch (quality) {
                    case DIAMOND: {
                        return new ItemStack((Item)Items.field_151173_ae);
                    }
                    case GOLD: {
                        return new ItemStack((Item)Items.field_151149_ai);
                    }
                    case IRON: {
                        return new ItemStack((Item)Items.field_151165_aa);
                    }
                    case STONE: {
                        return new ItemStack((Item)Items.field_151022_W);
                    }
                }
                return new ItemStack((Item)Items.field_151026_S);
            }
        }
        return null;
    }

    public static ItemStack dyeArmor(ItemStack armor, Color color) {
        NBTTagCompound nbtdata = armor.func_77978_p();
        if (nbtdata == null) {
            nbtdata = new NBTTagCompound();
            armor.func_77982_d(nbtdata);
        }
        NBTTagCompound nbtDisplay = nbtdata.func_74775_l("display");
        if (!nbtdata.func_74764_b("display")) {
            nbtdata.func_74782_a("display", (NBTBase)nbtDisplay);
        }
        nbtDisplay.func_74768_a("color", color.asInt());
        return armor;
    }

    @Override
    public ItemStack getLootItem(Random rand, int level) {
        if (this.equipment != null || this.quality != null) {
            return ItemArmour.get(rand, level, this.quality, this.equipment, this.enchant);
        }
        return ItemArmour.getRandom(rand, level, true);
    }
}

