/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import greymerk.roguelike.treasure.loot.Quality;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum Equipment {
    SWORD("sword", false, Items.field_151041_m, Items.field_151052_q, Items.field_151040_l, Items.field_151010_B, Items.field_151048_u),
    BOW("minecraft:bow", false, (Item)Items.field_151031_f, (Item)Items.field_151031_f, (Item)Items.field_151031_f, (Item)Items.field_151031_f, (Item)Items.field_151031_f),
    HELMET("helmet", true, (Item)Items.field_151024_Q, (Item)Items.field_151020_U, (Item)Items.field_151028_Y, (Item)Items.field_151169_ag, (Item)Items.field_151161_ac),
    CHEST("chestplate", true, (Item)Items.field_151027_R, (Item)Items.field_151023_V, (Item)Items.field_151030_Z, (Item)Items.field_151171_ah, (Item)Items.field_151163_ad),
    LEGS("leggings", true, (Item)Items.field_151026_S, (Item)Items.field_151022_W, (Item)Items.field_151165_aa, (Item)Items.field_151149_ai, (Item)Items.field_151173_ae),
    FEET("boots", true, (Item)Items.field_151021_T, (Item)Items.field_151029_X, (Item)Items.field_151167_ab, (Item)Items.field_151151_aj, (Item)Items.field_151175_af),
    PICK("pickaxe", false, Items.field_151039_o, Items.field_151050_s, Items.field_151035_b, Items.field_151005_D, Items.field_151046_w),
    AXE("axe", false, Items.field_151053_p, Items.field_151049_t, Items.field_151036_c, Items.field_151006_E, Items.field_151056_x),
    SHOVEL("shovel", false, Items.field_151038_n, Items.field_151051_r, Items.field_151037_a, Items.field_151011_C, Items.field_151047_v);

    private String name;
    private boolean isArmor;
    private Item wood;
    private Item stone;
    private Item iron;
    private Item gold;
    private Item diamond;

    private Equipment(String name, boolean isArmor, Item wood, Item stone, Item iron, Item gold, Item diamond) {
        this.name = name;
        this.isArmor = isArmor;
        this.wood = wood;
        this.stone = stone;
        this.iron = iron;
        this.gold = gold;
        this.diamond = diamond;
    }

    public ItemStack get(Quality quality) {
        return new ItemStack(this.getItem(quality));
    }

    private Item getItem(Quality quality) {
        switch (quality) {
            case WOOD: {
                return this.wood;
            }
            case STONE: {
                return this.stone;
            }
            case IRON: {
                return this.iron;
            }
            case GOLD: {
                return this.gold;
            }
            case DIAMOND: {
                return this.diamond;
            }
        }
        return Items.field_151055_y;
    }

    public String getMinecraftName(Quality quality) {
        String qualityName = this.isArmor ? quality.getArmorName() : quality.getToolName();
        return "minecraft:" + qualityName + "_" + this.name;
    }
}

