/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.theme;

import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.settings.DungeonSettingParseException;
import greymerk.roguelike.theme.BlockSet;
import greymerk.roguelike.theme.BlockSetParser;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.theme.ThemeBase;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;

public class ThemeParser {
    public static final String THEME_BASE_KEY = "base";
    public static final String PRIMARY_KEY = "primary";
    public static final String SECONDARY_KEY = "secondary";

    public static ThemeBase parse(JsonObject json) throws DungeonSettingParseException {
        ThemeBase themeBase = json.has(THEME_BASE_KEY) ? ThemeParser.get(json.get(THEME_BASE_KEY).getAsString()).getThemeBase() : null;
        BlockSet primaryBlockSet = Optional.ofNullable(ThemeParser.parsePrimaryBlockSet(json, themeBase)).orElse(Optional.ofNullable(themeBase).map(ThemeBase::getPrimary).orElse(null));
        BlockSet secondaryBlockSet = Optional.ofNullable(ThemeParser.parseSecondaryBlockSet(json, themeBase)).orElse(Optional.ofNullable(themeBase).map(ThemeBase::getSecondary).orElse(null));
        return new ThemeBase(primaryBlockSet, secondaryBlockSet);
    }

    private static BlockSet parsePrimaryBlockSet(JsonObject json, ThemeBase base) throws DungeonSettingParseException {
        return ThemeParser.parseBlockSet(json, base, PRIMARY_KEY, ThemeBase::getPrimary);
    }

    private static BlockSet parseSecondaryBlockSet(JsonObject json, ThemeBase base) throws DungeonSettingParseException {
        return ThemeParser.parseBlockSet(json, base, SECONDARY_KEY, ThemeBase::getSecondary);
    }

    private static BlockSet parseBlockSet(JsonObject json, ThemeBase baseTheme, String key, Function<ThemeBase, BlockSet> getBlockSetFunction) throws DungeonSettingParseException {
        if (!json.has(key)) {
            return null;
        }
        JsonObject data = json.get(key).getAsJsonObject();
        BlockSet baseBlockSet = Optional.ofNullable(baseTheme).map(getBlockSetFunction).orElse(ThemeParser.getEmptyBlockSet());
        return BlockSetParser.parseBlockSet(data, baseBlockSet);
    }

    private static BlockSet getEmptyBlockSet() {
        return new BlockSet(null, null, null, null, null, null, null);
    }

    public static Theme get(String name) throws DungeonSettingParseException {
        if (!ThemeParser.contains(name.toUpperCase())) {
            throw new DungeonSettingParseException("No such theme: " + name);
        }
        return Theme.valueOf(name.toUpperCase());
    }

    public static boolean contains(String name) {
        return Arrays.stream(Theme.values()).anyMatch(value -> value.toString().equals(name));
    }
}

