/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.towers;

import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.normal.Wood;
import greymerk.roguelike.dungeon.towers.ITower;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.Line;
import greymerk.roguelike.worldgen.shapes.MultiShape;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.shapes.Sphere;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TreeTower
implements ITower {
    public static final Wood WOOD_TYPE = Wood.OAK;

    @Override
    public void generate(WorldEditor editor, Random rand, ThemeBase theme, Coord origin) {
        Coord ground = Tower.getBaseCoord(editor, origin);
        Coord upstairs = ground.copy();
        upstairs.up(7);
        BlockBrush log = WOOD_TYPE.getLog();
        Coord start = ground.copy();
        start.down(10);
        Branch tree = new Branch(rand, start);
        tree.genWood(editor);
        tree.genLeaves(editor, rand);
        start = ground.copy();
        start.translate(new Coord(-3, -3, -3));
        Coord end = ground.copy();
        end.translate(new Coord(3, 3, 3));
        RectSolid.newRect(start, end).fill(editor, log);
        this.carveRoom(editor, ground);
        this.carveRoom(editor, upstairs);
        Direction dir = Direction.randomCardinal(rand);
        start = ground.copy();
        end = ground.copy();
        end.up();
        end.translate(dir, 8);
        RectSolid.newRect(start, end).fill(editor, SingleBlockBrush.AIR);
        start = ground.copy();
        end = ground.copy();
        end.translate(new Coord(8, 8, 8));
        new Sphere(start, end).fill(editor, log, false, true);
        start = upstairs.copy();
        start.down();
        for (Coord p : new RectSolid(start, origin)) {
            editor.spiralStairStep(rand, p, theme.getPrimary().getStair(), theme.getPrimary().getPillar());
        }
    }

    private void carveRoom(WorldEditor editor, Coord origin) {
        BlockBrush log = WOOD_TYPE.getLog();
        int size = 4;
        Coord start = origin.copy();
        start.translate(new Coord(-(size - 1), 0, -(size - 1)));
        Coord end = origin.copy();
        end.translate(new Coord(size - 1, 2, size - 1));
        SingleBlockBrush.AIR.fill(editor, new RectSolid(start, end));
        start = origin.copy();
        end = start.copy();
        start.up(2);
        end.translate(new Coord(size - 1, size - 1, size - 1));
        new Sphere(start, end).fill(editor, SingleBlockBrush.AIR);
        for (Direction dir : Direction.CARDINAL) {
            start = origin.copy();
            start.translate(dir, size - 1);
            start.translate(dir.antiClockwise(), size - 1);
            end = start.copy();
            end.up(size + 1);
            new RectSolid(start, end).fill(editor, log);
        }
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-(size - 1), -1, -(size - 1)));
        end.translate(new Coord(size - 1, -1, size - 1));
        new RectSolid(start, end).fill(editor, log);
    }

    private static class Branch {
        Coord start;
        Coord end;
        List<Branch> branches;
        double thickness;

        public Branch(Random rand, Coord start) {
            this.start = start.copy();
            this.branches = new ArrayList<Branch>();
            int counter = 7;
            double length = 12.0;
            this.thickness = 7.0;
            int mainBranches = 5;
            int density = 3;
            double noise = 0.15;
            double pitch = 0.0;
            double yaw = 1.5707963267948966;
            this.end = this.getEnd(start, 4.0, pitch, yaw);
            for (int i = 0; i < mainBranches; ++i) {
                this.branches.add(new Branch(rand, this.end.copy(), counter, length, this.thickness, 4, noise, pitch + Math.PI * 2 / (double)density * (double)i, yaw + (rand.nextDouble() - 0.5) * noise));
            }
        }

        public Branch(Random rand, Coord start, int counter, double length, double thickness, int density, double noise, double pitch, double yaw) {
            this.start = start.copy();
            this.thickness = thickness < 1.0 ? 1.0 : thickness;
            this.branches = new ArrayList<Branch>();
            this.end = this.getEnd(start, length, pitch, yaw);
            if (counter <= 0) {
                return;
            }
            for (int i = 0; i < rand.nextInt(density) + 1; ++i) {
                this.branches.add(new Branch(rand, this.end.copy(), counter - (rand.nextInt(2) + 1), length < 1.0 ? 1.0 : length * 0.88, thickness * 0.72, density, noise + thickness / 5.0 * 0.55, pitch + (rand.nextDouble() - 0.5) * noise, yaw + (rand.nextDouble() - 0.5) * noise));
            }
        }

        public void genWood(WorldEditor editor) {
            BlockBrush log = WOOD_TYPE.getLog().setFacing(this.start.dirTo(this.end));
            for (Branch b : this.branches) {
                b.genWood(editor);
            }
            if (this.thickness == 1.0) {
                new Line(this.start, this.end).fill(editor, log, true, false);
            } else if (this.thickness > 1.0) {
                MultiShape shape = new MultiShape();
                for (Coord pos : new Line(this.start, this.end)) {
                    Coord s = pos.copy();
                    Coord e = s.copy();
                    e.translate(new Coord((int)this.thickness, (int)this.thickness, (int)this.thickness));
                    shape.addShape(new Sphere(s, e));
                }
                shape.fill(editor, log);
            }
        }

        public void genLeaves(WorldEditor editor, Random rand) {
            MultiShape leafShape = new MultiShape();
            this.getLeafShape(leafShape, rand);
            BlockWeightedRandom leaves = new BlockWeightedRandom();
            leaves.addBlock(WOOD_TYPE.getLeaves(), 5);
            leaves.addBlock(SingleBlockBrush.AIR, 1);
            leafShape.fill(editor, leaves, true, false);
        }

        public void getLeafShape(MultiShape leaves, Random rand) {
            if (!this.branches.isEmpty()) {
                for (Branch b : this.branches) {
                    b.getLeafShape(leaves, rand);
                }
                return;
            }
            Coord s = this.end.copy();
            Coord e = s.copy();
            int size = 2;
            int noise = 2;
            e.translate(new Coord(2 + rand.nextInt(2), 2 + rand.nextInt(2), 2 + rand.nextInt(2)));
            leaves.addShape(new Sphere(s, e));
        }

        private Coord getEnd(Coord start, double length, double pitch, double yaw) {
            Coord offset = new Coord((int)(Math.cos(pitch) * Math.cos(yaw) * length), (int)(Math.sin(yaw) * length), (int)(Math.sin(pitch) * Math.cos(yaw) * length));
            Coord end = start.copy();
            end.translate(offset);
            return end;
        }
    }
}

