/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.builtin;

import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.base.RoomsSetting;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.settings.base.SettingsBase;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.treasure.loot.WeightedRandomLoot;
import greymerk.roguelike.treasure.loot.rule.ForEachLootRule;
import greymerk.roguelike.treasure.loot.rule.SingleUseLootRule;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.filter.Filter;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;

public class SettingsSwampTheme
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "swamp");

    public SettingsSwampTheme() {
        super(ID);
        int i;
        this.setExclusive(true);
        this.getInherit().add(SettingsBase.ID);
        this.getCriteria().setBiomeTypes(Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP}));
        this.setTowerSettings(new TowerSettings(Tower.WITCH, Theme.DARKOAK));
        Theme[] themes = new Theme[]{Theme.DARKHALL, Theme.DARKHALL, Theme.MUDDY, Theme.MOSSY, Theme.NETHER};
        WeightedRandomizer<ItemStack> brewing = new WeightedRandomizer<ItemStack>();
        brewing.add(new WeightedRandomLoot(Items.field_151069_bo, 0, 1, 3, 3));
        brewing.add(new WeightedRandomLoot(Items.field_151064_bs, 0, 1, 2, 1));
        brewing.add(new WeightedRandomLoot(Items.field_151060_bw, 0, 1, 3, 1));
        brewing.add(new WeightedRandomLoot(Items.field_151065_br, 0, 1, 3, 1));
        brewing.add(new WeightedRandomLoot(Items.field_151102_aT, 0, 1, 3, 1));
        for (i = 0; i < 5; ++i) {
            this.getLootRules().add(new ForEachLootRule(brewing, i, 2));
            this.getLootRules().add(new SingleUseLootRule(new WeightedRandomLoot(Items.field_151123_aH, 0, 1, 1 + i, 1), i, 4 + i * 3));
        }
        for (i = 0; i < 5; ++i) {
            RoomsSetting factory;
            SegmentGenerator segments;
            LevelSettings level = new LevelSettings();
            level.setTheme(themes[i].getThemeBase());
            if (i == 0) {
                segments = new SegmentGenerator(Segment.ARCH);
                segments.add(Segment.DOOR, 8);
                segments.add(Segment.LAMP, 2);
                segments.add(Segment.FLOWERS, 1);
                segments.add(Segment.MUSHROOM, 2);
                level.setSegments(segments);
                factory = new RoomsSetting();
                factory.add(RoomType.CAKE.newSingleRoomSetting());
                factory.add(RoomType.DARKHALL.newSingleRoomSetting());
                factory.add(RoomType.BRICK.newRandomRoomSetting(10));
                factory.add(RoomType.CORNER.newRandomRoomSetting(3));
                level.setRooms(factory);
                level.addFilter(Filter.MUD);
            }
            if (i == 1) {
                segments = new SegmentGenerator(Segment.ARCH);
                segments.add(Segment.DOOR, 8);
                segments.add(Segment.SHELF, 4);
                segments.add(Segment.INSET, 4);
                segments.add(Segment.MUSHROOM, 3);
                level.setSegments(segments);
                factory = new RoomsSetting();
                factory.add(RoomType.CAKE.newSingleRoomSetting());
                factory.add(RoomType.LAB.newSingleRoomSetting());
                factory.add(RoomType.SPIDER.newSingleRoomSetting());
                factory.add(RoomType.PIT.newSingleRoomSetting());
                factory.add(RoomType.PRISON.newSingleRoomSetting());
                factory.add(RoomType.BRICK.newRandomRoomSetting(10));
                factory.add(RoomType.CORNER.newRandomRoomSetting(3));
                level.setRooms(factory);
                level.addFilter(Filter.MUD);
            }
            this.getLevelSettings().put(i, level);
        }
        this.getLevelSettings().get(2).addFilter(Filter.VINE);
        this.getLevelSettings().get(3).addFilter(Filter.VINE);
    }
}

