/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import com.github.srwaggon.minecraft.block.BlockType;
import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.decorative.TorchBlock;
import com.github.srwaggon.minecraft.block.decorative.VineBlock;
import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import com.github.srwaggon.minecraft.item.Arrow;
import com.github.srwaggon.minecraft.item.Potion;
import com.github.srwaggon.minecraft.item.RldItemStack;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class SegmentTrap
extends SegmentBase {
    @Override
    protected void genWall(WorldEditor editor, Random rand, DungeonLevel level, Direction dir, ThemeBase theme, Coord origin) {
        SingleBlockBrush plate = BlockType.PRESSURE_PLATE_STONE.getBrush();
        SingleBlockBrush wire = BlockType.REDSTONE_WIRE.getBrush();
        VineBlock vine = VineBlock.vine();
        StairsBlock stair = theme.getPrimary().getStair();
        BlockBrush wall = theme.getPrimary().getWall();
        Direction[] orth = dir.orthogonals();
        Coord start = origin.copy();
        start.translate(dir, 2);
        Coord end = start.copy();
        start.translate(orth[0]);
        end.translate(orth[1]);
        end.up(2);
        RectSolid.newRect(start, end).fill(editor, vine);
        start.translate(dir);
        end.translate(dir);
        RectSolid.newRect(start, end).fill(editor, wall);
        Coord cursor = origin.copy();
        cursor.up();
        cursor.translate(dir, 3);
        SingleBlockBrush.AIR.stroke(editor, cursor);
        for (Direction side : orth) {
            cursor = origin.copy();
            cursor.translate(dir, 2);
            cursor.translate(side);
            stair.setUpsideDown(false).setFacing(side.reverse()).stroke(editor, cursor);
            cursor.up(2);
            stair.setUpsideDown(true).setFacing(side.reverse()).stroke(editor, cursor);
        }
        start = origin.copy();
        end = start.copy();
        start.translate(dir);
        end.translate(dir.reverse());
        RectSolid.newRect(start, end).fill(editor, plate);
        end.down(2);
        start = end.copy();
        start.translate(dir, 3);
        RectSolid.newRect(start, end).fill(editor, wire);
        cursor = start.copy();
        cursor.translate(dir, 2);
        TorchBlock.redstone().setFacing(dir).stroke(editor, cursor);
        cursor.up(2);
        TorchBlock.redstone().setFacing(Direction.UP).stroke(editor, cursor);
        cursor.up();
        this.placeTrap(editor, rand, dir, cursor);
    }

    private void placeTrap(WorldEditor editor, Random rand, Direction dir, Coord cursor) {
        Direction towardsCenter = dir.reverse();
        BlockType.DISPENSER.getBrush().setFacing(towardsCenter).stroke(editor, cursor);
        for (int i = 0; i < 5; ++i) {
            int slot = rand.nextInt(9);
            RldItemStack payload = Arrow.newRandomHarmful(rand).asItemStack();
            editor.setItem(cursor, slot, payload);
        }
        editor.setItem(cursor, 5, this.choosePayload(rand));
        this.unblockDispenser(editor, cursor, towardsCenter);
    }

    private void unblockDispenser(WorldEditor editor, Coord cursor, Direction towardsCenter) {
        SingleBlockBrush.AIR.stroke(editor, cursor.translate(towardsCenter));
        SingleBlockBrush.AIR.stroke(editor, cursor.translate(towardsCenter));
        SingleBlockBrush.AIR.stroke(editor, cursor.translate(towardsCenter));
    }

    private RldItemStack choosePayload(Random rand) {
        switch (rand.nextInt(3)) {
            default: {
                return BlockType.TNT.asItemStack();
            }
            case 1: {
                return Potion.newPotion().withType(Potion.Type.POISON).withForm(Potion.Form.SPLASH).asItemStack();
            }
            case 2: 
        }
        return Potion.newPotion().withType(Potion.Type.HARMING).withForm(Potion.Form.SPLASH).asItemStack();
    }
}

