/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import com.github.srwaggon.minecraft.block.BlockType;
import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import com.github.srwaggon.minecraft.block.normal.Wood;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class SegmentJungle
extends SegmentBase {
    @Override
    protected void genWall(WorldEditor editor, Random rand, DungeonLevel level, Direction wallDirection, ThemeBase theme, Coord origin) {
        StairsBlock stair = theme.getSecondary().getStair();
        SingleBlockBrush leaves = Wood.JUNGLE.getLeaves();
        Direction[] orthogonals = wallDirection.orthogonals();
        Coord start = origin.copy();
        start.translate(wallDirection, 2);
        Coord end = start.copy();
        start.translate(orthogonals[0], 1);
        end.translate(orthogonals[1], 1);
        end.up(1);
        RectSolid.newRect(start, end).fill(editor, SingleBlockBrush.AIR);
        start.down();
        end.down(2);
        if (rand.nextInt(5) == 0) {
            RectSolid.newRect(start, end).fill(editor, BlockType.WATER_FLOWING.getBrush());
        } else {
            RectSolid.newRect(start, end).fill(editor, BlockType.GRASS.getBrush());
            start.up(1);
            end.up(1);
            if (rand.nextBoolean()) {
                RectSolid.newRect(start, end).fill(editor, leaves);
            }
        }
        for (Direction d : orthogonals) {
            Coord cursor = origin.copy();
            cursor.translate(wallDirection, 2);
            cursor.translate(d, 1);
            cursor.up(1);
            stair.setUpsideDown(true).setFacing(d.reverse());
            stair.stroke(editor, cursor);
        }
    }
}

