/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.srwaggon.minecraft.block.BlockType;
import com.github.srwaggon.minecraft.block.SingleBlockBrush;
import com.github.srwaggon.minecraft.block.decorative.Crop;
import com.github.srwaggon.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.List;
import java.util.Random;

public class NetherFortressRoom
extends DungeonBase {
    public NetherFortressRoom(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        ThemeBase theme = this.levelSettings.getTheme();
        BlockBrush wall = theme.getPrimary().getWall();
        StairsBlock stair = theme.getPrimary().getStair();
        BlockBrush liquid = theme.getPrimary().getLiquid();
        BlockWeightedRandom netherwart = new BlockWeightedRandom();
        netherwart.addBlock(SingleBlockBrush.AIR, 3);
        netherwart.addBlock(Crop.NETHER_WART.getBrush(), 1);
        Coord start = origin.copy();
        Coord end = origin.copy();
        start.translate(new Coord(-8, -1, -8));
        end.translate(new Coord(8, 6, 8));
        RectHollow.newRect(start, end).fill(this.worldEditor, wall, false, true);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-4, 6, -4));
        end.translate(new Coord(4, 6, 4));
        RectSolid.newRect(start, end).fill(this.worldEditor, wall);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-3, 7, -3));
        end.translate(new Coord(3, 7, 3));
        RectSolid.newRect(start, end).fill(this.worldEditor, wall);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-2, 7, -2));
        end.translate(new Coord(2, 7, 2));
        RectSolid.newRect(start, end).fill(this.worldEditor, liquid);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-4, -1, -4));
        end.translate(new Coord(4, -3, 4));
        RectSolid.newRect(start, end).fill(this.worldEditor, wall, false, true);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-3, -2, -3));
        end.translate(new Coord(3, -2, 3));
        BlockType.SOUL_SAND.getBrush().fill(this.worldEditor, new RectSolid(start, end), false, true);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-3, -1, -3));
        end.translate(new Coord(3, -1, 3));
        RectSolid.newRect(start, end).fill(this.worldEditor, netherwart, false, true);
        List<Coord> chests = new RectSolid(start, end).get();
        List<Coord> chestLocations = this.chooseRandomLocations(this.worldEditor.getRandom(origin).nextInt(3) + 1, chests);
        ChestType chestType = this.getRoomSetting().getChestType().orElse(ChestType.chooseRandomAmong(this.worldEditor.getRandom(origin), ChestType.RARE_TREASURES));
        this.worldEditor.getTreasureChestEditor().createChests(chestLocations, false, this.levelSettings.getDifficulty(origin), chestType);
        for (Direction dir : Direction.CARDINAL) {
            start = origin.copy();
            start.translate(Direction.UP, 5);
            start.translate(dir, 4);
            end = start.copy();
            start.translate(dir.antiClockwise(), 6);
            end.translate(dir.clockwise(), 6);
            RectSolid.newRect(start, end).fill(this.worldEditor, wall);
            start = origin.copy();
            start.translate(Direction.UP, 5);
            start.translate(dir, 6);
            end = start.copy();
            start.translate(dir.antiClockwise(), 6);
            end.translate(dir.clockwise(), 6);
            RectSolid.newRect(start, end).fill(this.worldEditor, wall);
            start = origin.copy();
            start.translate(Direction.DOWN);
            start.translate(dir, 4);
            end = start.copy();
            start.translate(dir.antiClockwise(), 2);
            end.translate(dir.clockwise(), 2);
            stair.setUpsideDown(false).setFacing(dir.reverse()).fill(this.worldEditor, new RectSolid(start, end));
            Coord cursor = origin.copy();
            cursor.translate(dir, 4);
            cursor.translate(dir.antiClockwise(), 4);
            this.supportPillar(this.worldEditor, this.worldEditor.getRandom(cursor), this.levelSettings, cursor);
            for (Direction o : dir.orthogonals()) {
                cursor = origin.copy();
                cursor.translate(dir, 7);
                cursor.translate(o, 2);
                this.pillar(this.worldEditor, this.levelSettings, cursor);
                cursor.translate(o);
                cursor.translate(o);
                cursor.translate(o);
                this.pillar(this.worldEditor, this.levelSettings, cursor);
            }
        }
        return this;
    }

    private void supportPillar(WorldEditor editor, Random rand, LevelSettings levelSettings, Coord origin) {
        Coord end;
        Coord start;
        ThemeBase theme = levelSettings.getTheme();
        BlockBrush pillar = theme.getPrimary().getPillar();
        StairsBlock stair = theme.getPrimary().getStair();
        SingleBlockBrush lava = BlockType.LAVA_FLOWING.getBrush();
        for (Direction dir : Direction.CARDINAL) {
            start = origin.copy();
            start.translate(dir);
            end = start.copy();
            end.translate(Direction.UP, 5);
            RectSolid.newRect(start, end).fill(editor, pillar);
            Coord cursor = origin.copy();
            cursor.translate(dir, 2);
            cursor.translate(Direction.UP, 4);
            stair.setUpsideDown(true).setFacing(dir).stroke(editor, cursor);
        }
        start = origin.copy();
        end = start.copy();
        end.translate(Direction.UP, 5);
        RectSolid.newRect(start, end).fill(editor, lava);
        List<Coord> core = new RectSolid(start, end).get();
        Coord spawnerLocation = core.get(rand.nextInt(core.size()));
        this.generateSpawner(spawnerLocation, new MobType[0]);
    }

    private void pillar(WorldEditor editor, LevelSettings settings, Coord origin) {
        ThemeBase theme = settings.getTheme();
        BlockBrush wall = theme.getPrimary().getWall();
        BlockBrush pillar = theme.getPrimary().getPillar();
        StairsBlock stair = theme.getPrimary().getStair();
        Coord start = origin.copy();
        Coord end = start.copy();
        end.translate(Direction.UP, 5);
        RectSolid.newRect(start, end).fill(editor, pillar);
        for (Direction dir : Direction.CARDINAL) {
            Coord cursor = origin.copy();
            cursor.translate(Direction.UP, 4);
            cursor.translate(dir);
            stair.setUpsideDown(true).setFacing(dir).stroke(editor, cursor, true, false);
            cursor.translate(Direction.UP);
            wall.stroke(editor, cursor);
        }
    }

    @Override
    public int getSize() {
        return 10;
    }
}

