/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import com.github.srwaggon.minecraft.block.BlockType;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.List;

public class DungeonsCreeperDen
extends DungeonBase {
    public static final BlockBrush TNT_META_BLOCK = BlockType.TNT.getBrush();

    public DungeonsCreeperDen(RoomSetting roomSetting, LevelSettings levelSettings, WorldEditor worldEditor) {
        super(roomSetting, levelSettings, worldEditor);
    }

    @Override
    public DungeonBase generate(Coord origin, List<Direction> entrances) {
        ThemeBase theme = this.levelSettings.getTheme();
        BlockWeightedRandom mossy = new BlockWeightedRandom();
        mossy.addBlock(theme.getPrimary().getWall(), 3);
        mossy.addBlock(BlockType.COBBLESTONE_MOSSY.getBrush(), 1);
        BlockWeightedRandom floor = new BlockWeightedRandom();
        floor.addBlock(theme.getPrimary().getFloor(), 1);
        mossy.addBlock(BlockType.COBBLESTONE_MOSSY.getBrush(), 1);
        floor.addBlock(BlockType.GRAVEL.getBrush(), 3);
        BlockWeightedRandom subfloor = new BlockWeightedRandom();
        subfloor.addBlock(floor, 3);
        subfloor.addBlock(TNT_META_BLOCK, 1);
        Coord start = origin.copy();
        Coord end = origin.copy();
        start.translate(new Coord(-4, -4, -4));
        end.translate(new Coord(4, 5, 4));
        RectHollow.newRect(start, end).fill(this.worldEditor, mossy, false, true);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-3, -1, -3));
        end.translate(new Coord(3, -1, 3));
        RectSolid.newRect(start, end).fill(this.worldEditor, floor);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-3, -3, -3));
        end.translate(new Coord(3, -2, 3));
        RectSolid.newRect(start, end).fill(this.worldEditor, subfloor);
        start = origin.copy();
        end = origin.copy();
        start.translate(new Coord(-3, 0, -3));
        end.translate(new Coord(3, 0, 3));
        List<Coord> chestSpaces = new RectSolid(start, end).get();
        this.chooseRandomLocations(3, chestSpaces).stream().peek(chestSpace -> this.worldEditor.getTreasureChestEditor().createChest((Coord)chestSpace, true, this.levelSettings.getDifficulty((Coord)chestSpace), this.getRoomSetting().getChestType().orElse(ChestType.ORE))).forEach(chestSpace -> this.spawnTntBeneath(this.worldEditor, (Coord)chestSpace));
        Coord cursor = origin.copy();
        this.generateSpawner(cursor, MobType.CREEPER);
        return this;
    }

    private void spawnTntBeneath(WorldEditor editor, Coord coord) {
        Coord cursor = coord.copy();
        cursor.down(2);
        TNT_META_BLOCK.stroke(editor, cursor);
    }

    @Override
    public int getSize() {
        return 7;
    }
}

