/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.dungeon.DungeonNode;
import greymerk.roguelike.dungeon.DungeonTunnel;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.worldgen.IBounded;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public class LevelLayout {
    private List<DungeonNode> nodes = new ArrayList<DungeonNode>();
    private List<DungeonTunnel> tunnels = new ArrayList<DungeonTunnel>();
    private DungeonNode start;
    private DungeonNode end;

    public DungeonNode getStart() {
        return this.start;
    }

    public void setStart(DungeonNode start) {
        this.start = start;
        this.addNode(start);
    }

    public DungeonNode getEnd() {
        return this.end;
    }

    public void setEnd(DungeonNode end) {
        this.end = end;
        this.addNode(end);
    }

    public void addNode(DungeonNode node) {
        this.nodes.add(node);
    }

    public void addTunnel(DungeonTunnel tunnel) {
        this.tunnels.add(tunnel);
    }

    public void addTunnels(List<DungeonTunnel> tunnels) {
        this.tunnels.addAll(tunnels);
    }

    public List<DungeonNode> getNodes() {
        return this.nodes;
    }

    public List<DungeonTunnel> getTunnels() {
        return this.tunnels;
    }

    public void setStartEnd(Random rand, DungeonNode start) {
        this.start = start;
        int attempts = 0;
        do {
            this.end = this.nodes.get(rand.nextInt(this.nodes.size()));
        } while (this.end == this.start || this.end.getPosition().distance(start.getPosition()) > (double)(16 + ++attempts * 2));
    }

    private boolean anyTunnelsOverlap(DungeonNode node, int size) {
        return this.getTunnels().stream().anyMatch(tunnel -> node.overlaps(size, (DungeonTunnel)tunnel));
    }

    private boolean anyNodesOverlap(DungeonNode node, int size) {
        return this.getNodes().stream().anyMatch(other -> node.overlaps(size, (DungeonNode)other));
    }

    public DungeonNode getBestFit(DungeonBase room) {
        return this.getNonOverlappingConnectingNode(room).orElseGet(this::getConnectingNode);
    }

    private Optional<DungeonNode> getNonOverlappingConnectingNode(DungeonBase room) {
        return this.getNodes().stream().filter(this::isConnectingNode).filter(DungeonNode::isNotYetGenerated).filter(node -> !this.overlaps((DungeonNode)node, room.getSize())).findFirst();
    }

    private DungeonNode getConnectingNode() {
        return this.getNodes().stream().filter(this::isConnectingNode).filter(DungeonNode::isNotYetGenerated).findFirst().orElse(null);
    }

    private boolean overlaps(DungeonNode node, int size) {
        return this.anyTunnelsOverlap(node, size) || this.anyNodesOverlap(node, size);
    }

    private boolean isConnectingNode(DungeonNode node) {
        return node != this.start && node != this.end;
    }

    public boolean hasEmptyRooms() {
        return this.nodes.stream().filter(this::isConnectingNode).anyMatch(DungeonNode::isNotYetGenerated);
    }

    public List<IBounded> getBoundingBoxes() {
        ArrayList<IBounded> boxes = new ArrayList<IBounded>();
        boxes.addAll(this.nodes);
        boxes.addAll(this.tunnels);
        return boxes;
    }
}

