/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.dungeon.DungeonNode;
import greymerk.roguelike.dungeon.DungeonTunnel;
import greymerk.roguelike.dungeon.ILevelGenerator;
import greymerk.roguelike.dungeon.LevelLayout;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class LevelGeneratorClassic
implements ILevelGenerator {
    private static final int MIN_ROOMS = 6;
    private Random random;
    private LevelLayout layout;
    private LevelSettings settings;
    private Coord start;

    public LevelGeneratorClassic(Random random, LevelSettings settings) {
        this.random = random;
        this.layout = new LevelLayout();
        this.settings = settings;
    }

    @Override
    public void generate(Coord start) {
        this.start = start;
        ArrayList<Node> gNodes = new ArrayList<Node>();
        Node startNode = new Node(Direction.randomCardinal(this.random), start);
        gNodes.add(startNode);
        while (!this.isDone(gNodes)) {
            this.update(gNodes);
        }
        for (Node n : gNodes) {
            n.cull();
        }
        DungeonNode startDungeonNode = null;
        for (Node n : gNodes) {
            DungeonNode nToAdd = n.createNode();
            if (n == startNode) {
                startDungeonNode = nToAdd;
            }
            this.layout.addNode(nToAdd);
            this.layout.addTunnels(n.createTunnels());
        }
        this.layout.setStartEnd(this.random, startDungeonNode);
    }

    public void update(List<Node> nodes) {
        if (!this.full(nodes)) {
            for (int i = 0; i < nodes.size(); ++i) {
                nodes.get(i).update(nodes);
            }
        }
    }

    private boolean isDone(List<Node> nodes) {
        boolean allDone = true;
        for (Node node : nodes) {
            if (node.isDone()) continue;
            allDone = false;
        }
        return allDone || this.full(nodes);
    }

    private boolean full(List<Node> nodes) {
        return nodes.size() >= Math.max(this.settings.getNumRooms(), 6);
    }

    public void spawnNode(List<Node> nodes, Tunneler tunneler) {
        Node toAdd = new Node(tunneler.getDirection(), tunneler.getPosition());
        nodes.add(toAdd);
    }

    public boolean hasNearbyNode(List<Node> nodes, Coord pos, int min) {
        for (Node node : nodes) {
            int dist = (int)node.getPos().distance(pos);
            if (dist >= min) continue;
            return true;
        }
        return false;
    }

    @Override
    public LevelLayout getLayout() {
        return this.layout;
    }

    private class Node {
        private List<Tunneler> tunnelers = new ArrayList<Tunneler>();
        private Direction direction;
        private Coord pos;

        public Node(Direction direction, Coord pos) {
            this.direction = direction;
            this.pos = pos;
            this.spawnTunnelers();
        }

        private void spawnTunnelers() {
            if (LevelGeneratorClassic.this.start.distance(this.pos) > (double)LevelGeneratorClassic.this.settings.getRange()) {
                return;
            }
            for (Direction dir : Direction.CARDINAL) {
                if (dir.equals((Object)this.direction.reverse())) continue;
                this.tunnelers.add(new Tunneler(dir, this.pos.copy()));
            }
        }

        public void update(List<Node> nodes) {
            for (Tunneler tunneler : this.tunnelers) {
                tunneler.update(nodes);
            }
        }

        public boolean isDone() {
            for (Tunneler tunneler : this.tunnelers) {
                if (tunneler.isDone()) continue;
                return false;
            }
            return true;
        }

        public Coord getPos() {
            return this.pos.copy();
        }

        public List<Direction> getEntrances() {
            ArrayList<Direction> entrances = new ArrayList<Direction>();
            entrances.add(this.direction.reverse());
            this.tunnelers.stream().map(tunneler -> ((Tunneler)tunneler).dir).forEach(entrances::add);
            return entrances;
        }

        public List<DungeonTunnel> createTunnels() {
            ArrayList<DungeonTunnel> tunnels = new ArrayList<DungeonTunnel>();
            for (Tunneler t : this.tunnelers) {
                tunnels.add(t.createTunnel());
            }
            return tunnels;
        }

        public DungeonNode createNode() {
            return new DungeonNode(this.getEntrances(), this.pos);
        }

        public void cull() {
            ArrayList<Tunneler> toKeep = new ArrayList<Tunneler>();
            for (Tunneler t : this.tunnelers) {
                if (!t.done) continue;
                toKeep.add(t);
            }
            this.tunnelers = toKeep;
        }
    }

    private class Tunneler {
        private boolean done = false;
        private Direction dir;
        private Coord start;
        private Coord end;
        private int extend;

        public Tunneler(Direction dir, Coord start) {
            this.dir = dir;
            this.start = start.copy();
            this.end = start.copy();
            this.extend = LevelGeneratorClassic.this.settings.getScatter() * 2;
        }

        public void update(List<Node> nodes) {
            if (this.done) {
                return;
            }
            if (LevelGeneratorClassic.this.hasNearbyNode(nodes, this.end, LevelGeneratorClassic.this.settings.getScatter())) {
                this.end.translate(this.dir);
            } else if (LevelGeneratorClassic.this.random.nextInt(this.extend) == 0) {
                LevelGeneratorClassic.this.spawnNode(nodes, this);
                this.done = true;
            } else {
                this.end.translate(this.dir);
                --this.extend;
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public Direction getDirection() {
            return this.dir;
        }

        public Coord getPosition() {
            return this.end.copy();
        }

        public DungeonTunnel createTunnel() {
            return new DungeonTunnel(this.start.copy(), this.end.copy());
        }
    }
}

