/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import com.github.srwaggon.minecraft.block.Material;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.DungeonStage;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.SettingsRandom;
import greymerk.roguelike.dungeon.settings.SettingsResolver;
import greymerk.roguelike.dungeon.settings.SpawnCriteria;
import greymerk.roguelike.dungeon.tasks.DungeonTaskRegistry;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.VanillaStructure;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public class Dungeon {
    public static final int VERTICAL_SPACING = 10;
    public static final int TOPLEVEL = 50;
    public static final int CHUNK_SIZE = 16;
    public static SettingsResolver settingsResolver;
    private Coord origin;
    private final List<DungeonLevel> levels = new ArrayList<DungeonLevel>();
    private final WorldEditor editor;

    public Dungeon(WorldEditor editor) {
        this.editor = editor;
    }

    public static void initResolver() throws Exception {
        settingsResolver = SettingsResolver.initSettingsResolver();
    }

    public static boolean canSpawnInChunk(int chunkX, int chunkZ, WorldEditor editor) {
        return RogueConfig.DONATURALSPAWN.getBoolean() && SpawnCriteria.isValidDimension(Dungeon.getDimension(chunkX, chunkZ, editor)) && Dungeon.isSpawnFrequencyHit(chunkX, chunkZ) && Dungeon.isSpawnChanceHit(chunkX, chunkZ);
    }

    private static int getDimension(int chunkX, int chunkZ, WorldEditor editor) {
        Coord coord = new Coord(chunkX * 16, 0, chunkZ * 16);
        return editor.getInfo(coord).getDimension();
    }

    private static boolean isSpawnFrequencyHit(int chunkX, int chunkZ) {
        int frequency = Dungeon.getSpawnFrequency();
        return chunkX % frequency == 0 && chunkZ % frequency == 0;
    }

    private static int getSpawnFrequency() {
        return 3 * Math.max(2, RogueConfig.SPAWNFREQUENCY.getInt());
    }

    private static boolean isSpawnChanceHit(int chunkX, int chunkZ) {
        double spawnChance = RogueConfig.SPAWNCHANCE.getDouble();
        Random rand = new Random(Objects.hash(chunkX, chunkZ, 31));
        return (double)rand.nextFloat() < spawnChance;
    }

    public static int getLevel(int y) {
        if (y < 15) {
            return 4;
        }
        if (y < 25) {
            return 3;
        }
        if (y < 35) {
            return 2;
        }
        if (y < 45) {
            return 1;
        }
        return 0;
    }

    public void generate(DungeonSettings dungeonSettings, Coord coord) {
        try {
            Random random = this.editor.getRandom(coord);
            this.origin = new Coord(coord.getX(), 50, coord.getZ());
            IntStream.range(0, dungeonSettings.getNumLevels()).mapToObj(dungeonSettings::getLevelSettings).map(DungeonLevel::new).forEach(this.levels::add);
            Arrays.stream(DungeonStage.values()).flatMap(stage -> DungeonTaskRegistry.getTaskRegistry().getTasks((DungeonStage)((Object)stage)).stream()).forEach(task -> task.execute(this.editor, random, this, dungeonSettings));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void spawnInChunk(Random rand, int chunkX, int chunkZ) {
        if (Dungeon.canSpawnInChunk(chunkX, chunkZ, this.editor)) {
            int x = chunkX * 16;
            int z = chunkZ * 16;
            this.selectLocation(rand, x, z).ifPresent(coord -> this.getDungeonSettingsMaybe((Coord)coord).ifPresent(dungeonSettings -> this.generate((DungeonSettings)dungeonSettings, (Coord)coord)));
        }
    }

    private Optional<Coord> selectLocation(Random rand, int x, int z) {
        int attempts = RogueConfig.SPAWN_ATTEMPTS.getInt();
        return IntStream.range(0, attempts).mapToObj(i -> Dungeon.getNearbyCoord(rand, x, z)).filter(this::canGenerateDungeonHere).findFirst();
    }

    private static Coord getNearbyCoord(Random random, int x, int z) {
        int distance = random.nextInt(Dungeon.getSpawnRadius());
        double angle = random.nextDouble() * 2.0 * Math.PI;
        int xOffset = (int)(Math.cos(angle) * (double)distance);
        int zOffset = (int)(Math.sin(angle) * (double)distance);
        return new Coord(x + xOffset, 0, z + zOffset);
    }

    private static int getSpawnRadius() {
        int spawnDiameter = Dungeon.getSpawnFrequency() * 16;
        return spawnDiameter / 2;
    }

    public boolean canGenerateDungeonHere(Coord coord) {
        Predicate<VanillaStructure> isTooCloseTo = structure -> this.hasStructureTooCloseBy(coord, (VanillaStructure)((Object)structure));
        if (Arrays.stream(VanillaStructure.values()).anyMatch(isTooCloseTo)) {
            return false;
        }
        int upperLimit = RogueConfig.UPPERLIMIT.getInt();
        int lowerLimit = RogueConfig.LOWERLIMIT.getInt();
        Coord cursor = new Coord(coord.getX(), upperLimit, coord.getZ());
        return this.editor.isAirBlock(cursor) && this.canFindStartingCoord(lowerLimit, cursor) && this.isFreeOverhead(cursor) && this.isSolidBelow(cursor);
    }

    private boolean hasStructureTooCloseBy(Coord coord, VanillaStructure structure) {
        Coord structureCoord = this.editor.findNearestStructure(structure, coord);
        return structureCoord != null && coord.distance(structureCoord) < (double)RogueConfig.SPAWN_MINIMUM_DISTANCE_FROM_VANILLA_STRUCTURES.getInt();
    }

    private boolean canFindStartingCoord(int lowerLimit, Coord cursor) {
        while (!this.editor.validGroundBlock(cursor)) {
            cursor.down();
            if (cursor.getY() < lowerLimit) {
                return false;
            }
            if (!this.editor.isMaterialAt(Material.WATER, cursor)) continue;
            return false;
        }
        return true;
    }

    private boolean isFreeOverhead(Coord cursor) {
        Coord start = cursor.copy().translate(new Coord(-4, 4, -4));
        Coord end = cursor.copy().translate(new Coord(4, 4, 4));
        for (Coord c : new RectSolid(start, end)) {
            if (!this.editor.validGroundBlock(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isSolidBelow(Coord cursor) {
        Coord start1 = cursor.copy().translate(new Coord(-4, -3, -4));
        Coord end1 = cursor.copy().translate(new Coord(4, -3, 4));
        int airCount = 0;
        for (Coord c : new RectSolid(start1, end1)) {
            if (!this.editor.validGroundBlock(c)) {
                ++airCount;
            }
            if (airCount <= 8) continue;
            return false;
        }
        return true;
    }

    private Optional<DungeonSettings> getDungeonSettingsMaybe(Coord coord) {
        if (RogueConfig.RANDOM.getBoolean()) {
            return Optional.of(new SettingsRandom(this.editor.getRandom(coord)));
        }
        if (settingsResolver == null) {
            return Optional.empty();
        }
        return settingsResolver.chooseDungeonSetting(this.editor, coord);
    }

    public Coord getPosition() {
        return this.origin.copy();
    }

    public List<DungeonLevel> getLevels() {
        return this.levels;
    }

    static {
        try {
            RogueConfig.reload(false);
            Dungeon.initResolver();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

