/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.command;

import greymerk.roguelike.command.CommandContext;
import greymerk.roguelike.command.ICommandRouter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;

public abstract class CommandRouteBase
implements ICommandRouter {
    private Map<String, ICommandRouter> routes = new HashMap<String, ICommandRouter>();

    protected void addRoute(String id, ICommandRouter route) {
        this.routes.put(id, route);
    }

    @Override
    public void execute(CommandContext context, List<String> args) {
        if (args.size() > 0 && this.routes.containsKey(args.get(0))) {
            ArrayList<String> tail = new ArrayList<String>(args);
            String head = (String)tail.remove(0);
            this.routes.get(head).execute(context, tail);
        }
    }

    @Override
    public List<String> getTabCompletion(List<String> args) {
        ArrayList<String> tail;
        String head;
        if (args.size() == 1) {
            return this.getListTabOptions(args.get(0), this.routes.keySet());
        }
        if (args.size() > 1 && this.routes.containsKey(head = (String)(tail = new ArrayList<String>(args)).remove(0))) {
            return this.routes.get(head).getTabCompletion(tail);
        }
        return Collections.emptyList();
    }

    protected List<String> getListTabOptions(String name, Collection<String> possibilities) {
        ArrayList<String> options = new ArrayList<String>();
        for (String item : possibilities) {
            if (!CommandBase.func_71523_a((String)name, (String)item)) continue;
            options.add(item);
        }
        return options;
    }
}

