/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.skill.farming;

import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.unlockable.Trait;
import codersafterdark.reskillable.base.LevelLockHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TraitHungryFarmer
extends Trait {
    public TraitHungryFarmer() {
        super(new ResourceLocation("Reskillable", "hungry_farmer"), 2, 3, new ResourceLocation("reskillable", "farming"), 8, "reskillable:farming|32");
    }

    @Override
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int playerHunger;
        EntityPlayer player = event.player;
        if (player == null || player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        PlayerData data = PlayerDataHandler.get(player);
        if (data != null && data.getSkillInfo(this.getParentSkill()).isUnlocked(this) && (playerHunger = player.func_71024_bL().func_75116_a()) < 20) {
            NonNullList inventoryList = player.field_71069_bz.func_75138_a();
            ItemStack currentStack = ItemStack.field_190927_a;
            int hungerNeeded = 20 - playerHunger;
            int bestHungerPoints = 0;
            for (ItemStack stack : inventoryList) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemFood) || !LevelLockHandler.canPlayerUseItem(player, stack)) continue;
                int hungerPoints = ((ItemFood)stack.func_77973_b()).func_150905_g(stack);
                if (!currentStack.func_190926_b() && (hungerPoints >= bestHungerPoints || hungerPoints < hungerNeeded) && (hungerPoints <= bestHungerPoints || bestHungerPoints >= hungerNeeded)) continue;
                currentStack = stack;
                bestHungerPoints = hungerPoints;
                if (bestHungerPoints != hungerNeeded) continue;
                break;
            }
            if (!currentStack.func_190926_b()) {
                currentStack.func_77973_b().func_77654_b(currentStack, player.func_130014_f_(), (EntityLivingBase)player);
            }
        }
    }
}

