/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.network;

import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.event.UnlockUnlockableEvent;
import codersafterdark.reskillable.api.skill.Skill;
import codersafterdark.reskillable.api.unlockable.Unlockable;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageUnlockUnlockable
implements IMessage,
IMessageHandler<MessageUnlockUnlockable, IMessage> {
    private ResourceLocation skill;
    private ResourceLocation unlockable;

    public MessageUnlockUnlockable() {
    }

    public MessageUnlockUnlockable(ResourceLocation skill, ResourceLocation unlockable) {
        this.skill = skill;
        this.unlockable = unlockable;
    }

    public void fromBytes(ByteBuf buf) {
        this.skill = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.unlockable = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.skill.toString());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.unlockable.toString());
    }

    public IMessage onMessage(MessageUnlockUnlockable message, MessageContext ctx) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> this.handleMessage(message, ctx));
        return null;
    }

    public IMessage handleMessage(MessageUnlockUnlockable message, MessageContext context) {
        EntityPlayerMP player = context.getServerHandler().field_147369_b;
        Skill skill = (Skill)ReskillableRegistries.SKILLS.getValue(message.skill);
        Unlockable unlockable = (Unlockable)Objects.requireNonNull(ReskillableRegistries.UNLOCKABLES.getValue(message.unlockable));
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        PlayerSkillInfo info = data.getSkillInfo(skill);
        if (!info.isUnlocked(unlockable) && info.getSkillPoints() >= unlockable.getCost() && data.matchStats(unlockable.getRequirements()) && !MinecraftForge.EVENT_BUS.post((Event)new UnlockUnlockableEvent.Pre((EntityPlayer)player, unlockable))) {
            info.unlock(unlockable, (EntityPlayer)player);
            data.saveAndSync();
            MinecraftForge.EVENT_BUS.post((Event)new UnlockUnlockableEvent.Post((EntityPlayer)player, unlockable));
        }
        return null;
    }
}

