/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.api.requirement;

import codersafterdark.reskillable.api.ReskillableAPI;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.requirement.RequirementComparision;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class AdvancementRequirement
extends Requirement {
    private ResourceLocation advancementName;

    public AdvancementRequirement(ResourceLocation advancementName) {
        this.advancementName = advancementName;
    }

    @Override
    public boolean achievedByPlayer(EntityPlayer entityPlayer) {
        return Optional.ofNullable(this.getAdvancement()).map(advancement -> ReskillableAPI.getInstance().getAdvancementProgress(entityPlayer, (Advancement)advancement)).map(AdvancementProgress::func_192105_a).orElse(false);
    }

    @Override
    public String getToolTip(PlayerData data) {
        if (this.tooltip.isEmpty()) {
            Advancement adv = this.getAdvancement();
            this.tooltip = TextFormatting.GRAY + " - " + TextFormatting.GOLD + new TextComponentTranslation("reskillable.requirements.format.advancement", new Object[]{"%S", adv == null ? "" : adv.func_193123_j().func_150260_c().replaceAll("[\\[\\]]", "")}).func_150261_e();
        }
        return super.getToolTip(data);
    }

    public Advancement getAdvancement() {
        return RequirementHolder.getAdvancementList().func_192084_a(this.advancementName);
    }

    @Override
    public RequirementComparision matches(Requirement other) {
        return other instanceof AdvancementRequirement && this.advancementName.equals((Object)((AdvancementRequirement)other).advancementName) ? RequirementComparision.EQUAL_TO : RequirementComparision.NOT_EQUAL;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof AdvancementRequirement && this.advancementName.equals((Object)((AdvancementRequirement)o).advancementName);
    }

    public int hashCode() {
        return this.advancementName.hashCode();
    }
}

