/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import xreliquary.items.ItemToggleable;
import xreliquary.util.StackHelper;
import xreliquary.util.WorldHelper;

public class InventoryHelper {
    private InventoryHelper() {
    }

    public static void spawnItemStack(World world, double x, double y, double z, @Nonnull ItemStack stack) {
        Random rnd = new Random();
        float f = rnd.nextFloat() * 0.8f + 0.1f;
        float f1 = rnd.nextFloat() * 0.8f + 0.1f;
        float f2 = rnd.nextFloat() * 0.8f + 0.1f;
        EntityItem entityitem = new EntityItem(world, x + (double)f, y + (double)f1, z + (double)f2, stack);
        float f3 = 0.05f;
        entityitem.field_70159_w = rnd.nextGaussian() * (double)f3;
        entityitem.field_70181_x = rnd.nextGaussian() * (double)f3 + (double)0.2f;
        entityitem.field_70179_y = rnd.nextGaussian() * (double)f3;
        world.func_72838_d((Entity)entityitem);
    }

    @Nonnull
    public static ItemStack getTargetItem(@Nonnull ItemStack self, IItemHandler inventory) {
        if (self.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack targetItem = ItemStack.field_190927_a;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (StackHelper.isItemAndNbtEqual(self, stack) || stack.func_77976_d() == 1 || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.func_77946_l();
        }
        return targetItem;
    }

    public static int getItemQuantity(@Nonnull ItemStack stack, IItemHandler inventory) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack newStack = inventory.getStackInSlot(slot);
            if (!StackHelper.isItemAndNbtEqual(stack, newStack)) continue;
            itemQuantity += newStack.func_190916_E();
        }
        return itemQuantity;
    }

    public static boolean consumeItem(String itemName, int meta, boolean ignoreMeta, EntityPlayer player) {
        return InventoryHelper.consumeItem((ItemStack is) -> is.func_77973_b().getRegistryName().toString().equals(itemName) && (ignoreMeta || is.func_77960_j() == meta), player);
    }

    public static boolean consumeItem(Function<ItemStack, Boolean> itemMatches, EntityPlayer player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            int stackSize;
            ItemStack slotStack;
            if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190926_b() || !itemMatches.apply(slotStack = (ItemStack)player.field_71071_by.field_70462_a.get(slot)).booleanValue() || (stackSize = slotStack.func_190916_E()) <= 0) continue;
            slotStack.func_190918_g(1);
            if (slotStack.func_190916_E() <= 0) {
                player.field_71071_by.field_70462_a.set(slot, (Object)ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public static boolean consumeItem(ItemStack item, EntityPlayer player) {
        return InventoryHelper.consumeItem(item, player, 0, 1);
    }

    public static boolean consumeItem(@Nonnull ItemStack item, EntityPlayer player, int minCount) {
        return InventoryHelper.consumeItem(item, player, minCount, 1);
    }

    public static boolean consumeItem(@Nonnull ItemStack itemStack, EntityPlayer player, int minCount, int countToConsume) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (itemStack.func_190926_b() || countToConsume <= 0) {
            return false;
        }
        int itemCount = 0;
        ArrayList<AbstractMap.SimpleEntry<Integer, Integer>> slotCounts = new ArrayList<AbstractMap.SimpleEntry<Integer, Integer>>();
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            ItemStack slotStack = (ItemStack)player.field_71071_by.field_70462_a.get(slot);
            if (!StackHelper.isItemAndNbtEqual(slotStack, itemStack)) continue;
            int n = slotStack.func_190916_E();
            itemCount += n;
            slotCounts.add(new AbstractMap.SimpleEntry<Integer, Integer>(slot, n));
        }
        if (itemCount - countToConsume < minCount) {
            return false;
        }
        if (itemCount >= countToConsume) {
            slotCounts.sort((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue()));
            int countToFill = itemCount - countToConsume;
            for (Map.Entry entry : slotCounts) {
                int slot = (Integer)entry.getKey();
                if (countToFill > 0) {
                    int stackSizeToFill = Math.min(itemStack.func_77976_d(), countToFill);
                    player.field_71071_by.func_70301_a(slot).func_190920_e(stackSizeToFill);
                    countToFill -= stackSizeToFill;
                    continue;
                }
                player.field_71071_by.func_70298_a(slot, player.field_71071_by.func_70301_a(slot).func_190916_E());
            }
            return true;
        }
        return false;
    }

    public static int tryToRemoveFromInventory(@Nonnull ItemStack contents, IItemHandler inventory, int maxToRemove) {
        int remaining = maxToRemove;
        ItemStack stackToExtract = contents.func_77946_l();
        int currentStackCount = Math.min(remaining, stackToExtract.func_77976_d());
        stackToExtract.func_190920_e(currentStackCount);
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack extractedStack;
            if (inventory.getStackInSlot(slot).func_190926_b()) continue;
            while (inventory.getStackInSlot(slot).func_190916_E() > 0 && StackHelper.isItemAndNbtEqual(inventory.getStackInSlot(slot), contents) && remaining > 0 && (extractedStack = inventory.extractItem(slot, Math.min(maxToRemove, inventory.getStackInSlot(slot).func_190916_E()), false)).func_190916_E() != 0) {
                stackToExtract = contents.func_77946_l();
                currentStackCount = Math.min(remaining -= extractedStack.func_190916_E(), stackToExtract.func_77976_d());
                stackToExtract.func_190920_e(currentStackCount);
            }
            if (remaining <= 0) break;
        }
        return maxToRemove - remaining;
    }

    public static Optional<IItemHandler> getInventoryAtPos(World world, BlockPos pos) {
        return InventoryHelper.getInventoryAtPos(world, pos, null);
    }

    public static Optional<IItemHandler> getInventoryAtPos(World world, BlockPos pos, @Nullable EnumFacing side) {
        return WorldHelper.getTile((IBlockAccess)world, pos).map(te -> InventoryHelper.getItemHandlerFrom(te, side)).orElse(Optional.empty());
    }

    public static IItemHandler getItemHandlerFrom(EntityPlayer player, @Nullable EnumFacing facing) {
        return (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
    }

    public static IItemHandler getItemHandlerFrom(EntityPlayer player) {
        return InventoryHelper.getItemHandlerFrom(player, EnumFacing.UP);
    }

    public static Optional<IItemHandler> getItemHandlerFrom(TileEntity te) {
        return InventoryHelper.getItemHandlerFrom(te, null);
    }

    private static Optional<IItemHandler> getItemHandlerFrom(TileEntity te, @Nullable EnumFacing side) {
        if (InventoryHelper.hasItemHandler(te, side)) {
            return Optional.of(te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side));
        }
        return Optional.empty();
    }

    public static int insertIntoInventory(@Nonnull ItemStack contents, IItemHandler inventory) {
        return InventoryHelper.tryToAddToInventory(contents, inventory, contents.func_190916_E());
    }

    public static int tryToAddToInventory(@Nonnull ItemStack contents, IItemHandler inventory, int maxToAdd) {
        int inventorySize = inventory.getSlots();
        int remaining = maxToAdd;
        ItemStack stackToInsert = contents.func_77946_l();
        int currentStackCount = Math.min(remaining, stackToInsert.func_77976_d());
        stackToInsert.func_190920_e(currentStackCount);
        for (int slot = 0; slot < inventorySize; ++slot) {
            while (inventory.insertItem(slot, stackToInsert, true).func_190916_E() < stackToInsert.func_190916_E()) {
                ItemStack remainingStack = inventory.insertItem(slot, stackToInsert, false);
                if (remainingStack.func_190916_E() >= currentStackCount) continue;
                if ((remaining -= currentStackCount - remainingStack.func_190916_E()) <= 0) {
                    return maxToAdd;
                }
                stackToInsert = contents.func_77946_l();
                currentStackCount = Math.min(remaining, stackToInsert.func_77976_d());
                stackToInsert.func_190920_e(currentStackCount);
            }
        }
        return maxToAdd - remaining;
    }

    public static void tryRemovingLastStack(IItemHandler inventory, World world, BlockPos pos) {
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            if (inventory.getStackInSlot(i).func_190926_b()) continue;
            ItemStack stack = inventory.getStackInSlot(i).func_77946_l();
            inventory.extractItem(i, stack.func_190916_E(), false);
            if (world.field_72995_K) {
                return;
            }
            EntityItem itemEntity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, stack);
            world.func_72838_d((Entity)itemEntity);
            break;
        }
    }

    public static boolean tryAddingPlayerCurrentItem(EntityPlayer player, IItemHandler inventory, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand).func_77946_l();
        stack.func_190920_e(1);
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack remainingStack = inventory.insertItem(slot, stack, false);
            if (!remainingStack.func_190926_b()) continue;
            player.func_184586_b(hand).func_190918_g(1);
            if (player.func_184586_b(hand).func_190916_E() == 0) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            player.field_71071_by.func_70296_d();
            return true;
        }
        return false;
    }

    public static boolean playerHasItem(EntityPlayer player, Item item) {
        return InventoryHelper.playerHasItem(player, item, false);
    }

    public static boolean playerHasItem(EntityPlayer player, Item item, boolean checkEnabled) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            return !checkEnabled || !(stack.func_77973_b() instanceof ItemToggleable) || ((ItemToggleable)stack.func_77973_b()).isEnabled(stack);
        }
        if (Loader.isModLoaded((String)"baubles")) {
            IBaublesItemHandler inventoryBaubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < inventoryBaubles.getSlots(); ++i) {
                ItemStack baubleStack = inventoryBaubles.getStackInSlot(i);
                if (baubleStack.func_190926_b() || baubleStack.func_77973_b() != item) continue;
                return !checkEnabled || !(baubleStack.func_77973_b() instanceof ItemToggleable) || ((ItemToggleable)baubleStack.func_77973_b()).isEnabled(baubleStack);
            }
        }
        return false;
    }

    @Nonnull
    public static ItemStack getCorrectItemFromEitherHand(EntityPlayer player, Item item) {
        if (player == null) {
            return ItemStack.field_190927_a;
        }
        EnumHand itemInHand = InventoryHelper.getHandHoldingCorrectItem(player, item);
        if (itemInHand == null) {
            return ItemStack.field_190927_a;
        }
        return player.func_184586_b(itemInHand);
    }

    private static EnumHand getHandHoldingCorrectItem(EntityPlayer player, Item item) {
        if (player.func_184614_ca().func_77973_b() == item) {
            return EnumHand.MAIN_HAND;
        }
        if (player.func_184592_cb().func_77973_b() == item) {
            return EnumHand.OFF_HAND;
        }
        return null;
    }

    public static void addItemToPlayerInventory(EntityPlayer player, ItemStack ist) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (!player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            player.field_71071_by.func_70299_a(i, ist);
            return;
        }
        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, ist));
    }

    public static NonNullList<ItemStack> getItemStacks(IItemHandler inventory) {
        NonNullList ret = NonNullList.func_191196_a();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ret.add((Object)inventory.getStackInSlot(slot));
        }
        return ret;
    }

    public static void dropInventoryItems(World world, BlockPos pos) {
        WorldHelper.getTile((IBlockAccess)world, pos).ifPresent(te -> InventoryHelper.getItemHandlerFrom(te).ifPresent(itemHandler -> InventoryHelper.dropInventoryItems(world, pos, itemHandler)));
    }

    private static void dropInventoryItems(World world, BlockPos pos, IItemHandler inventory) {
        InventoryHelper.dropInventoryItems(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), inventory);
    }

    private static void dropInventoryItems(World world, double x, double y, double z, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            InventoryHelper.spawnItemStack(world, x, y, z, itemstack);
        }
    }

    public static boolean hasItemHandler(World world, BlockPos pos) {
        return WorldHelper.getTile((IBlockAccess)world, pos).map(InventoryHelper::hasItemHandler).orElse(false);
    }

    private static boolean hasItemHandler(TileEntity te) {
        return InventoryHelper.hasItemHandler(te, null);
    }

    private static boolean hasItemHandler(TileEntity te, @Nullable EnumFacing side) {
        return te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
    }
}

