/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.ArrayUtils;
import xreliquary.Reliquary;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;

public class ItemMidasTouchstone
extends ItemToggleable {
    private static final Map<Class<? extends Item>, IRepairableItem> REPAIRABLE_ITEMS = new ImmutableMap.Builder().put(ItemSword.class, item -> ((ItemSword)item).func_150932_j().equals(Item.ToolMaterial.GOLD.name())).put(ItemTool.class, item -> ((ItemTool)item).func_77861_e().equals(Item.ToolMaterial.GOLD.name())).put(ItemHoe.class, item -> ((ItemHoe)item).func_77842_f().equals(Item.ToolMaterial.GOLD.name())).put(ItemArmor.class, item -> ((ItemArmor)item).func_82812_d().equals((Object)ItemArmor.ArmorMaterial.GOLD)).build();

    public ItemMidasTouchstone() {
        super("midas_touchstone");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addMoreInformation(ItemStack touchstone, @Nullable World world, List<String> tooltip) {
        LanguageHelper.formatTooltip(this.func_77657_g(touchstone) + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(NBTHelper.getInteger("glowstone", touchstone))), tooltip);
        if (this.isEnabled(touchstone)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.YELLOW + Items.field_151114_aO.func_77653_i(new ItemStack(Items.field_151114_aO)))), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean f) {
        if (world.field_72995_K) {
            return;
        }
        if (!(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e;
        if (this.isEnabled(ist) && NBTHelper.getInteger("glowstone", ist) + this.getGlowStoneWorth() <= this.getGlowstoneLimit() && InventoryHelper.consumeItem(new ItemStack(Items.field_151114_aO), player)) {
            NBTHelper.setInteger("glowstone", ist, NBTHelper.getInteger("glowstone", ist) + this.getGlowStoneWorth());
        }
        if (world.func_82737_E() % 4L == 0L) {
            this.doRepairAndDamageTouchstone(ist, player);
        }
    }

    private void doRepairAndDamageTouchstone(ItemStack ist, EntityPlayer player) {
        Object[] goldItems = Settings.Items.MidasTouchstone.goldItems;
        IItemHandler itemHandler = InventoryHelper.getItemHandlerFrom(player, null);
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            Item item = stack.func_77973_b();
            if (stack.func_77952_i() <= 0 || !stack.func_77973_b().func_77645_m()) continue;
            Optional<IRepairableItem> repairableItem = this.getRepairableItem(item.getClass());
            if (repairableItem.isPresent()) {
                if (!repairableItem.get().materialMatches(item)) continue;
                this.repairItem(stack, ist, player);
                continue;
            }
            if (!ArrayUtils.contains((Object[])goldItems, (Object)RegistryHelper.getItemRegistryName(item))) continue;
            this.repairItem(stack, ist, player);
        }
    }

    private void repairItem(ItemStack stack, ItemStack touchstone, EntityPlayer player) {
        if (this.decrementTouchStoneCharge(touchstone, player)) {
            stack.func_77964_b(stack.func_77952_i() - 1);
        }
    }

    private boolean decrementTouchStoneCharge(ItemStack ist, EntityPlayer player) {
        if (NBTHelper.getInteger("glowstone", ist) - this.getGlowStoneCost() >= 0 || player.field_71075_bZ.field_75098_d) {
            if (!player.field_71075_bZ.field_75098_d) {
                NBTHelper.setInteger("glowstone", ist, NBTHelper.getInteger("glowstone", ist) - this.getGlowStoneCost());
            }
            return true;
        }
        return false;
    }

    private int getGlowStoneCost() {
        return Settings.Items.MidasTouchstone.glowstoneCost;
    }

    private int getGlowStoneWorth() {
        return Settings.Items.MidasTouchstone.glowstoneWorth;
    }

    private int getGlowstoneLimit() {
        return Settings.Items.MidasTouchstone.glowstoneLimit;
    }

    private Optional<IRepairableItem> getRepairableItem(Class<? extends Item> item) {
        for (Map.Entry<Class<? extends Item>, IRepairableItem> repairableItem : REPAIRABLE_ITEMS.entrySet()) {
            if (!repairableItem.getKey().isAssignableFrom(item)) continue;
            return Optional.of(repairableItem.getValue());
        }
        return Optional.empty();
    }

    private static interface IRepairableItem {
        public boolean materialMatches(Item var1);
    }
}

