/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import xreliquary.Reliquary;
import xreliquary.entities.EntityEnderStaffProjectile;
import xreliquary.init.ModBlocks;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.FilteredItemHandlerProvider;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class ItemEnderStaff
extends ItemToggleable {
    public ItemEnderStaff() {
        super("ender_staff");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    private int getEnderStaffPearlCost() {
        return Settings.Items.EnderStaff.enderPearlCastCost;
    }

    private int getEnderStaffNodeWarpCost() {
        return Settings.Items.EnderStaff.enderPearlNodeWarpCost;
    }

    private int getEnderPearlWorth() {
        return Settings.Items.EnderStaff.enderPearlWorth;
    }

    private int getEnderPearlLimit() {
        return Settings.Items.EnderStaff.enderPearlLimit;
    }

    private int getNodeWarpCastTime() {
        return Settings.Items.EnderStaff.nodeWarpCastTime;
    }

    public String getMode(ItemStack ist) {
        if (NBTHelper.getString("mode", ist).equals("")) {
            this.setMode(ist, "cast");
        }
        return NBTHelper.getString("mode", ist);
    }

    private void setMode(ItemStack ist, String s) {
        NBTHelper.setString("mode", ist, s);
    }

    private void cycleMode(ItemStack ist) {
        if (this.getMode(ist).equals("cast")) {
            this.setMode(ist, "long_cast");
        } else if (this.getMode(ist).equals("long_cast")) {
            this.setMode(ist, "node_warp");
        } else {
            this.setMode(ist, "cast");
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack ist) {
        if (entityLiving.field_70170_p.field_72995_K) {
            return true;
        }
        if (!(entityLiving instanceof EntityPlayer)) {
            return true;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (player.func_70093_af()) {
            this.cycleMode(ist);
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FilteredItemHandlerProvider(new int[]{Settings.Items.EnderStaff.enderPearlLimit}, new Item[]{Items.field_151079_bi}, new int[]{Settings.Items.EnderStaff.enderPearlWorth});
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int slotNumber, boolean isSelected) {
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (!this.isEnabled(ist)) {
            return;
        }
        if (this.getPearlCount(ist) + this.getEnderPearlWorth() <= this.getEnderPearlLimit() && InventoryHelper.consumeItem(new ItemStack(Items.field_151079_bi), player)) {
            this.setPearlCount(ist, this.getPearlCount(ist) + this.getEnderPearlWorth());
        }
    }

    private void setPearlCount(@Nonnull ItemStack ist, int count) {
        IItemHandler itemHandler = (IItemHandler)ist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        filteredHandler.setTotalAmount(0, count);
    }

    private int getPearlCount(@Nonnull ItemStack staff) {
        return this.getPearlCount(staff, false);
    }

    public int getPearlCount(@Nonnull ItemStack staff, boolean isClient) {
        if (isClient) {
            return NBTHelper.getInteger("count", staff);
        }
        IItemHandler itemHandler = (IItemHandler)staff.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return 0;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.getTotalAmount(0);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entityLivingBase, int unadjustedCount) {
        if (!(entityLivingBase instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLivingBase;
        for (int particles = 0; particles < 2; ++particles) {
            player.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70170_p.field_73012_v.nextGaussian(), player.field_70170_p.field_73012_v.nextGaussian(), player.field_70170_p.field_73012_v.nextGaussian(), new int[0]);
        }
        if (unadjustedCount == 1) {
            player.func_184597_cx();
        }
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return this.getNodeWarpCastTime();
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (timeLeft == 1) {
            this.doWraithNodeWarpCheck(stack, player.field_70170_p, player);
        }
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack ist = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            if (this.getMode(ist).equals("cast") || this.getMode(ist).equals("long_cast")) {
                if (player.field_82175_bq) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)ist);
                }
                player.func_184609_a(hand);
                if (this.getPearlCount(ist) < this.getEnderStaffPearlCost() && !player.field_71075_bZ.field_75098_d) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)ist);
                }
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187595_bc, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                if (!player.field_70170_p.field_72995_K) {
                    EntityEnderStaffProjectile enderStaffProjectile = new EntityEnderStaffProjectile(player.field_70170_p, player, !this.getMode(ist).equals("long_cast"));
                    enderStaffProjectile.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                    player.field_70170_p.func_72838_d((Entity)enderStaffProjectile);
                    if (!player.field_71075_bZ.field_75098_d) {
                        this.setPearlCount(ist, this.getPearlCount(ist) - this.getEnderStaffPearlCost());
                    }
                }
            } else {
                player.func_184598_c(hand);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    private void doWraithNodeWarpCheck(ItemStack stack, World world, EntityPlayer player) {
        if (this.getPearlCount(stack) < this.getEnderStaffNodeWarpCost() && !player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74762_e("dimensionID") != this.getDimension(world)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "Out of range!"));
            }
        } else if (stack.func_77978_p() != null && world.func_180495_p(new BlockPos(stack.func_77978_p().func_74762_e("nodeX" + this.getDimension(world)), stack.func_77978_p().func_74762_e("nodeY" + this.getDimension(world)), stack.func_77978_p().func_74762_e("nodeZ" + this.getDimension(world)))).func_177230_c() == ModBlocks.wraithNode) {
            if (this.canTeleport(world, stack.func_77978_p().func_74762_e("nodeX" + this.getDimension(world)), stack.func_77978_p().func_74762_e("nodeY" + this.getDimension(world)), stack.func_77978_p().func_74762_e("nodeZ" + this.getDimension(world)))) {
                this.teleportPlayer(world, stack.func_77978_p().func_74762_e("nodeX" + this.getDimension(world)), stack.func_77978_p().func_74762_e("nodeY" + this.getDimension(world)), stack.func_77978_p().func_74762_e("nodeZ" + this.getDimension(world)), player);
                if (!player.field_71075_bZ.field_75098_d && !player.field_70170_p.field_72995_K) {
                    this.setPearlCount(stack, this.getPearlCount(stack) - this.getEnderStaffNodeWarpCost());
                }
            }
        } else if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("dimensionID")) {
            stack.func_77978_p().func_82580_o("dimensionID");
            stack.func_77978_p().func_82580_o("nodeX");
            stack.func_77978_p().func_82580_o("nodeY");
            stack.func_77978_p().func_82580_o("nodeZ");
            stack.func_77978_p().func_82580_o("cooldown");
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "Node dosen't exist!"));
            } else {
                player.func_184185_a(SoundEvents.field_187530_aT, 1.0f, 1.0f);
            }
        }
    }

    private boolean canTeleport(World world, int x, int y, int z) {
        return world.func_175623_d(new BlockPos(x, y + 1, z)) && world.func_175623_d(new BlockPos(x, y + 2, z));
    }

    private void teleportPlayer(World world, int x, int y, int z, EntityPlayer player) {
        player.func_70634_a((double)x + 0.5, (double)y + 0.875, (double)z + 0.5);
        player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        for (int particles = 0; particles < 2; ++particles) {
            world.func_175688_a(EnumParticleTypes.PORTAL, player.field_70165_t, player.field_70163_u, player.field_70161_v, world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), new int[0]);
        }
    }

    @Override
    protected void addMoreInformation(ItemStack staff, @Nullable World world, List<String> tooltip) {
        String charge = Integer.toString(this.getPearlCount(staff, true));
        String phrase = "Currently bound to ";
        String position = "";
        if (staff.func_77978_p() != null && staff.func_77978_p().func_74762_e("dimensionID") != this.getDimension(world)) {
            phrase = "Out of range!";
        } else {
            position = staff.func_77978_p() != null && staff.func_77978_p().func_74764_b("nodeX" + this.getDimension(world)) && staff.func_77978_p().func_74764_b("nodeY" + this.getDimension(world)) && staff.func_77978_p().func_74764_b("nodeZ" + this.getDimension(world)) ? "X: " + staff.func_77978_p().func_74762_e("nodeX" + this.getDimension(world)) + " Y: " + staff.func_77978_p().func_74762_e("nodeY" + this.getDimension(world)) + " Z: " + staff.func_77978_p().func_74762_e("nodeZ" + this.getDimension(world)) : "nowhere.";
        }
        LanguageHelper.formatTooltip(this.func_77657_g(staff) + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"phrase", (Object)phrase, (Object)"position", (Object)position, (Object)"charge", (Object)charge), tooltip);
        if (this.isEnabled(staff)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.GREEN + Items.field_151079_bi.func_77653_i(new ItemStack(Items.field_151079_bi)))), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!(stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("dimensionID") || world.func_180495_p(pos).func_177230_c() != ModBlocks.wraithNode)) {
            this.setWraithNode(stack, pos, this.getDimension(world));
            player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            for (int particles = 0; particles < 12; ++particles) {
                world.func_175688_a(EnumParticleTypes.PORTAL, (double)pos.func_177958_n() + world.field_73012_v.nextDouble(), (double)pos.func_177956_o() + world.field_73012_v.nextDouble(), (double)pos.func_177952_p() + world.field_73012_v.nextDouble(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), new int[0]);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private int getDimension(@Nullable World world) {
        return world != null ? world.field_73011_w.getDimension() : 0;
    }

    private void setWraithNode(ItemStack eye, BlockPos pos, int dimensionID) {
        NBTHelper.setInteger("nodeX" + dimensionID, eye, pos.func_177958_n());
        NBTHelper.setInteger("nodeY" + dimensionID, eye, pos.func_177956_o());
        NBTHelper.setInteger("nodeZ" + dimensionID, eye, pos.func_177952_p());
        NBTHelper.setInteger("dimensionID", eye, dimensionID);
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack staff) {
        NBTTagCompound nbt = super.getNBTShareTag(staff);
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74768_a("count", this.getPearlCount(staff));
        return nbt;
    }
}

