/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.potion;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xreliquary.network.PacketFXThrownPotionImpact;
import xreliquary.network.PacketHandler;

abstract class EntityThrownPotion
extends EntityThrowable {
    EntityThrownPotion(World world) {
        super(world);
    }

    EntityThrownPotion(World world, EntityPlayer player) {
        super(world, (EntityLivingBase)player);
    }

    EntityThrownPotion(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70184_a(@Nonnull RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            this.spawnParticles();
            this.doSplashEffect();
            this.func_70106_y();
        }
    }

    abstract boolean hasLivingEntityEffect();

    private void doSplashEffect() {
        this.doGroundSplashEffect();
        if (!this.hasLivingEntityEffect()) {
            return;
        }
        AxisAlignedBB bb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List eList = this.field_70170_p.func_72872_a(EntityLivingBase.class, bb);
        eList.forEach(this::doLivingSplashEffect);
    }

    abstract void doGroundSplashEffect();

    private void spawnParticles() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Random rand = this.field_70146_Z;
        for (int i = 0; i < 8; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t, this.field_70163_u, this.field_70161_v, rand.nextGaussian() * 0.15, rand.nextDouble() * 0.2, rand.nextGaussian() * 0.15, new int[]{Item.func_150891_b((Item)Items.field_151068_bn)});
        }
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        PacketHandler.networkWrapper.sendToAllAround((IMessage)new PacketFXThrownPotionImpact(this.getColor(), this.field_70165_t, this.field_70163_u, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
    }

    abstract void doLivingSplashEffect(EntityLivingBase var1);

    abstract int getColor();
}

