/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.random.item;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.reccomplex.random.Person;
import ivorius.reccomplex.random.Poem;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import org.apache.commons.lang3.text.WordUtils;

public class Book {
    public static final int LINES_PER_PAGE = 12;
    public static final int CHARS_PER_LINE = 18;

    public static ItemStack any(Random random) {
        return random.nextFloat() < 0.5f ? Book.generic(random) : Book.poem(random);
    }

    public static ItemStack generic(Random random) {
        ItemStack stack = new ItemStack(Items.field_151122_aG);
        String bookName = Person.chaoticName(random, random.nextFloat() < 0.8f);
        stack.func_151001_c(bookName);
        return stack;
    }

    public static ItemStack poem(Random random) {
        ItemStack stack = new ItemStack(Items.field_151164_bB);
        Person author = Person.randomHuman(random, random.nextFloat() < 0.9f);
        Poem poem = Poem.randomPoem(random, 32, author);
        stack.func_77983_a("pages", (NBTBase)NBTTagLists.write(Book.bookPages(poem.getText()).stream().map(Book::toJSON).map(NBTTagString::new).collect(Collectors.toList())));
        stack.func_77983_a("author", (NBTBase)new NBTTagString(author.getFullName()));
        stack.func_77983_a("title", (NBTBase)new NBTTagString(poem.getTitle()));
        return stack;
    }

    public static String toJSON(String text) {
        return new Gson().toJson((JsonElement)new JsonPrimitive(text));
    }

    public static List<String> bookPages(String text) {
        List lines = Arrays.stream(text.split("\n")).map(line -> line + "\n").flatMap(line -> Arrays.stream(WordUtils.wrap((String)line, (int)18, (String)"\r", (boolean)true).replaceAll("\r", " \r").split("\r"))).collect(Collectors.toList());
        return Lists.partition(lines, (int)12).stream().map(pageLines -> pageLines.stream().reduce("", (l, r) -> l + r)).collect(Collectors.toList());
    }
}

