/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.gentypes;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.RCGuiTables;
import ivorius.reccomplex.gui.editstructure.TableDataSourceBiomeGenList;
import ivorius.reccomplex.gui.editstructure.TableDataSourceDimensionGenList;
import ivorius.reccomplex.gui.editstructure.TableDataSourceNaturalGenLimitation;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceGenerationType;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceSelectivePlacer;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellEnum;
import ivorius.reccomplex.gui.table.cell.TableCellMultiBuilder;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.world.gen.feature.selector.NaturalStructureSelector;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.NaturalGeneration;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class TableDataSourceNaturalGeneration
extends TableDataSourceSegmented {
    private TableNavigator navigator;
    private TableDelegate tableDelegate;
    private NaturalGeneration generationInfo;

    public TableDataSourceNaturalGeneration(TableNavigator navigator, TableDelegate delegate, NaturalGeneration generationInfo) {
        this.navigator = navigator;
        this.tableDelegate = delegate;
        this.generationInfo = generationInfo;
        this.addSegment(0, new TableDataSourceGenerationType(generationInfo, navigator, delegate));
        this.addSegment(1, () -> {
            TableCellEnum<String> cell = new TableCellEnum<String>("category", generationInfo.generationCategory, TableDataSourceNaturalGeneration.allGenerationCategories());
            cell.addListener(val -> {
                generationInfo.generationCategory = val;
            });
            return new TitledCell(IvTranslations.get("reccomplex.generationInfo.natural.category"), cell);
        });
        this.addSegment(2, () -> RCGuiTables.defaultWeightElement(val -> generationInfo.setGenerationWeight(TableCells.toDouble(val)), generationInfo.getGenerationWeight()));
        this.addSegment(3, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceSelectivePlacer(generationInfo.placer, navigator, delegate), () -> IvTranslations.get("reccomplex.placer"), () -> IvTranslations.getLines("reccomplex.placer.tooltip")).withTitle("").buildDataSource());
        this.addSegment(4, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceBiomeGenList(generationInfo.biomeWeights, delegate, navigator), () -> IvTranslations.get("reccomplex.gui.biomes"), () -> IvTranslations.getLines("reccomplex.gui.biomes.tooltip")).addNavigation(() -> new TableDataSourceDimensionGenList(generationInfo.dimensionWeights, delegate, navigator), () -> IvTranslations.get("reccomplex.gui.dimensions"), () -> IvTranslations.getLines("reccomplex.gui.dimensions.tooltip")).withTitle("").buildDataSource());
        this.addSegment(5, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceNaturalGenLimitation(generationInfo.spawnLimitation, delegate)).enabled(generationInfo::hasLimitations).addAction(() -> {
            generationInfo.spawnLimitation = generationInfo.hasLimitations() ? null : new NaturalGeneration.SpawnLimitation();
        }, () -> generationInfo.hasLimitations() ? IvTranslations.get("reccomplex.gui.remove") : IvTranslations.get("reccomplex.gui.add"), null).withTitle(IvTranslations.get("reccomplex.generationInfo.natural.limitations")).buildDataSource());
    }

    public static List<TableCellEnum.Option<String>> allGenerationCategories() {
        Set<String> categories = NaturalStructureSelector.CATEGORY_REGISTRY.activeIDs();
        return categories.stream().map(category -> Pair.of((Object)category, (Object)NaturalStructureSelector.CATEGORY_REGISTRY.getActive((String)category))).filter(p -> ((NaturalStructureSelector.Category)p.getRight()).selectableInGUI()).map(p -> new TableCellEnum.Option<Object>(p.getLeft(), ((NaturalStructureSelector.Category)p.getRight()).title(), ((NaturalStructureSelector.Category)p.getRight()).tooltip())).sorted(Comparator.comparing(o -> o.title)).collect(Collectors.toList());
    }
}

