/*
 * Decompiled with CFR 0.152.
 */
package net.insane96mcp.progressivebosses.lib;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="progressivebosses", category="", name="ProgressiveBosses")
public class ModConfig {
    public static final ConfigOptions config = new ConfigOptions();

    @Mod.EventBusSubscriber(modid="progressivebosses")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("progressivebosses")) {
                ConfigManager.sync((String)"progressivebosses", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ConfigOptions {
        @Config.Name(value="Wither")
        @Config.Comment(value={"Difficulty is the amount of Withers Spawned"})
        public Wither wither = new Wither();
        @Config.Name(value="Ender Dragon")
        @Config.Comment(value={"Difficulty is the amount of Ender Dragons Killed"})
        public Dragon dragon = new Dragon();

        public static class Dragon {
            public General general = new General();
            public Health health = new Health();
            public Armor armor = new Armor();
            public Larvae larvae = new Larvae();
            public DragonMinions minions = new DragonMinions();
            public Rewards rewards = new Rewards();
            public Attack attack = new Attack();

            public static class Attack {
                @Config.Name(value="Bonus Attack Damage")
                @Config.Comment(value={"How much more percentage damage does the Ender Dragon deal per difficulty? Setting to 0 will disable this feature."})
                public float bonusDamage = 15.0f;
                @Config.Name(value="Full Chance to Attack")
                @Config.Comment(value={"Normally the Ender Dragon attacks only when leaving the center platform. With this active she has a chance each tick (1/20th of second) when roaming around to attack the player.\nThis defines the chance to attack the player each tick when all the crystals were destoyed and the difficulty is 24 (last End Gate to appear). The actual formula is\n(this_value / 23) * difficulty * (1 / remaining_crystals).\nSetting to 0 will disable this feature."})
                public float fullChanceToAttack = 0.5f;
            }

            public static class Rewards {
                @Config.Name(value="Bonus Experience")
                @Config.Comment(value={"How much more experience (percentage) will Ender Dragon drop per Difficulty. The percentage is additive (e.g. with this set to 10%, 7 Ender Dragons killed = 70% more experience)."})
                public float bonusExperience = 10.0f;
                @Config.Name(value="First Dragon per Player")
                @Config.Comment(value={"Should the first Dragon killed per Player always drop the egg and the first Dragon experience (12k instead of 500)? If true means that every player will get the Dragon Egg as they kill their first Dragon."})
                public boolean firstDragonPerPlayer = true;
            }

            public static class DragonMinions {
                @Config.Name(value="Difficulty to Spawn Minions")
                @Config.Comment(value={"Minimum Difficulty required for the Ender Dragon to start spawning Dragon's Minions during the fight. Set to -1 to disable Dragon's Minions spawning."})
                @Config.RangeInt(min=0, max=0x7FFFFFFF)
                public int difficultyToSpawn = 2;
                @Config.Name(value="Min Cooldown")
                @Config.Comment(value={"After how many minimum ticks (20 ticks = 1 second) the Ender Dragon will try to spawn a Minion."})
                @Config.RangeInt(min=1, max=0x7FFFFFFF)
                public int minCooldown = 1200;
                @Config.Name(value="Max Cooldown")
                @Config.Comment(value={"After how many maximum ticks (20 ticks = 1 second) the Ender Dragon will try to spawn a Minion."})
                @Config.RangeInt(min=1, max=0x7FFFFFFF)
                public int maxCooldown = 1800;
                @Config.Name(value="Cooldown Reduction per Difficulty")
                @Config.Comment(value={"For each difficulty the Minion spawn cooldown min and max values will be reduced by this value (E.g. with 10 difficulty and this set to 10, the Minion cooldown min will be 500 and max 1100)"})
                @Config.RangeInt(min=1, max=0x7FFFFFFF)
                public int spawnCooldownReduction = 10;
            }

            public static class Larvae {
                @Config.Name(value="Difficulty to Spawn One More Larva")
                @Config.Comment(value={"As the Ender Dragon Difficulty reaches this value she will be spawning a Larva during the fight. Plus every time Difficulty is a multiplier of this value the Ender Dragon will spawn one more Larva."})
                @Config.RangeInt(min=1, max=0x7FFFFFFF)
                public int difficultyToSpawnOneMore = 1;
                @Config.Name(value="Max Larvae Spawned")
                @Config.Comment(value={"Maximum number of Larvae that an Ender Dragon can spawn. Set to 0 to disable Dragon's Larvae."})
                @Config.RangeInt(min=0, max=0x7FFFFFFF)
                public int maxSpawned = 6;
                @Config.Name(value="Min Cooldown")
                @Config.Comment(value={"After how many minimum ticks (20 ticks = 1 second) the Ender Dragon will try to spawn Larvae."})
                @Config.RangeInt(min=1, max=0x7FFFFFFF)
                public int minCooldown = 1050;
                @Config.Name(value="Max Cooldown")
                @Config.Comment(value={"After how many minimum ticks (20 ticks = 1 second) the Ender Dragon will try to spawn Larvae."})
                @Config.RangeInt(min=1, max=0x7FFFFFFF)
                public int maxCooldown = 1200;
                @Config.Name(value="Cooldown Reduction per Difficulty")
                @Config.Comment(value={"For each difficulty the Larvae spawn cooldown min and max values will be reduced by this value (E.g. with 10 difficulty and this set to 5, the Larvae cooldown min will be 550 and max 1150)"})
                @Config.RangeInt(min=1, max=0x7FFFFFFF)
                public int cooldownReduction = 10;
            }

            public static class Armor {
                @Config.Name(value="Bonus Armor per Difficulty")
                @Config.Comment(value={"How much armor points will have Ender Dragons per Difficulty."})
                @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
                public float bonusPerDifficulty = 0.25f;
                @Config.Name(value="Maximum Armor")
                @Config.Comment(value={"Maximum armor points that Ender Dragons can spawn with. It's not recommended to go over 10 as the Ender Dragon already has some damage reduction"})
                @Config.RangeDouble(min=0.0, max=30.0)
                public float maximum = 2.5f;
            }

            public static class Health {
                @Config.Name(value="Health Bonus per Difficulty")
                @Config.Comment(value={"Increase Ender Dragon's Health by this value per difficulty."})
                @Config.RangeDouble(min=0.0, max=1024.0)
                public float bonusPerDifficulty = 10.0f;
                @Config.Name(value="Maximum Bonus Regeneration")
                @Config.Comment(value={"Maximum bonus regeneration per second given by \"Bonus Regeneration per Difficulty\". Set to 0 to disable bonus health regeneration. This doesn't affect the regeneration of the Ender Dragon from Crystals. It's not recommended to go over 1.0f without mods that adds stronger things to kill the Ender Dragon."})
                @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
                public float maximumBonusRegen = 0.5f;
                @Config.Name(value="Bonus Regeneration per Difficulty")
                @Config.Comment(value={"How many half hearts will the Ender Dragon regen per difficulty. This doesn't affect the regeneration of the Ender Dragon from Crystals. (E.g. With 6 Dragons killed, the Dragon will heal 0.6 health per second without Crystals)."})
                @Config.RangeDouble(min=0.0, max=1024.0)
                public float bonusRegenPerSpawned = 0.025f;
            }

            public static class General {
                @Config.Name(value="Sum Killed Dragons Difficulty")
                @Config.Comment(value={"If true and there are more players around the Dragon, she will have his stats based on the sum of both players' difficulty. If false, the Dragon stats will be based on the average of the difficulty of the players around."})
                public boolean sumKilledDragonsDifficulty = false;
                @Config.Name(value="Max Difficulty")
                @Config.Comment(value={"The Maximum difficulty (times killed) reachable by Ender Dragon. By default is set to 82 because the Ender Dragon reaches the maximum amount of health (1024, handled by Minecraft. Some mods can increase this) after 82 Dragons killed."})
                public int maxDifficulty = 82;
            }
        }

        public static class Wither {
            public General general = new General();
            public WitherMinions minions = new WitherMinions();
            public Health health = new Health();
            public Armor armor = new Armor();
            public Rewards rewards = new Rewards();

            public static class Rewards {
                @Config.Name(value="Bonus Experience per Difficulty")
                @Config.Comment(value={"How much more experience (percentage) will Wither drop per Difficulty. The percentage is additive (e.g. with this set to 10%, 7 withers spawned = 70% more experience)"})
                @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
                public float bonusExperience = 10.0f;
                @Config.Name(value="Shards per Difficulty")
                @Config.Comment(value={"How much chance per Difficulty to get a Nether Star Shard from killing the wither"})
                @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
                public float shardPerDifficulty = 2.0f;
                @Config.Name(value="Shards Max Chance")
                @Config.Comment(value={"Maximum chance to get a Nether Star shard."})
                @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
                public float shardMaxChance = 50.0f;
                @Config.Name(value="Shards Divider")
                @Config.Comment(value={"Difficulty Divider for how many times the game tries to drop one more shard. Given this value x you get ((difficulty / x) + 1) times to get one or more shard.\nE.g. By default, at 10 withers killed you have 6 times 20% chance to drop a shard."})
                @Config.RangeInt(min=1, max=0x7FFFFFFF)
                public int shardDivider = 2;
                @Config.Name(value="Shards Max Count")
                @Config.Comment(value={"Maximum amount of shards that you can get from a Wither"})
                @Config.RangeInt(min=0, max=0x7FFFFFFF)
                public int shardMaxCount = 8;
                @Config.Name(value="Custom Rewards")
                @Config.Comment(value={"A list of items that can be dropped by the Wither. Each line must have a different item. The format is item,difficulty,chance,mode.\nitem: The item id; supports metadata such as minecraft:stone:2\r\ndifficulty: the amount of difficulty required for the item to try to drop, works differently based on mode\r\nchance: chance for the item to drop\r\nmode: The mode used to be able to drop the item: \"once\": will only try to drop the item when the difficulty match the one specified; \"repeat\": will try to drop the item when the difficulty matches or is higher than the one specified, \"exponential\": will try to drop the item everytime difficulty is a multiple of the specified difficulty."})
                public String[] customRewards = new String[0];
            }

            public static class Armor {
                @Config.Name(value="Bonus Armor per Difficulty")
                @Config.Comment(value={"How much armor points will have Withers per Difficulty."})
                @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
                public float bonusPerDifficulty = 0.25f;
                @Config.Name(value="Maximum Armor")
                @Config.Comment(value={"Maximum armor that Withers can spawn with. It's not recommended to go over 20."})
                @Config.RangeDouble(min=0.0, max=30.0)
                public float maximum = 10.0f;
            }

            public static class Health {
                @Config.Name(value="Health Bonus per Difficulty")
                @Config.Comment(value={"Increase Wither's Health by this value per difficulty."})
                @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
                public float bonusPerDifficulty = 10.0f;
                @Config.Name(value="Maximum Bonus Regeneration")
                @Config.Comment(value={"Maximum bonus regeneration per second given by \"Bonus Regeneration per Difficulty\". Set to 0 to disable bonus health regeneration. This doesn't affect the natural regeneration of the Wither (1 Health per Second). It's not recommended to go over 1.0f without mods that adds stronger things to kill the Wither."})
                @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
                public float maximumBonusRegen = 1.0f;
                @Config.Name(value="Bonus Regeneration per Difficulty")
                @Config.Comment(value={"How many half hearts will the Wither regen more per difficulty. This doesn't affect the natural regeneration of the Wither (1 Health per Second). (E.g. With 6 Withers spawned, the Wither will heal 1.6 health per second)."})
                @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
                public float bonusRegenPerSpawned = 0.05f;
            }

            public static class WitherMinions {
                @Config.Name(value="Difficulty to Spawn Minions")
                @Config.Comment(value={"Minimum Difficulty required for the Wither will start spawning Wither Minions during the fight."})
                @Config.RangeInt(min=0, max=0x7FFFFFFF)
                public int difficultyToSpawn = 1;
                @Config.Name(value="Difficulty to Spawn One More Minion")
                @Config.Comment(value={"As the Wither starts spawning Minions, every how much difficulty the Wither will spawn one more Minion."})
                @Config.RangeInt(min=1, max=0x7FFFFFFF)
                public int difficultyToSpawnOneMore = 3;
                @Config.Name(value="Max Minions Spawned")
                @Config.Comment(value={"Maximum number of Wither Minions that a Wither can spawn. Set to 0 to disable Wither Minions."})
                @Config.RangeInt(min=0, max=0x7FFFFFFF)
                public int maxSpawned = 8;
                @Config.Name(value="Max Minions Around")
                @Config.Comment(value={"Maximum amount of Wither Minions that can be around the Wither in a 24 block radius. After this number is reached the Wither will stop spawning minions. Set to 0 to disable this check."})
                @Config.RangeInt(min=0, max=0x7FFFFFFF)
                public int maxAround = 16;
                @Config.Name(value="Min Cooldown")
                @Config.Comment(value={"After how many minimum ticks (20 ticks = 1 second) the Wither will try to spawn Minions"})
                @Config.RangeInt(min=1, max=0x7FFFFFFF)
                public int minCooldown = 150;
                @Config.Name(value="Max Cooldown")
                @Config.Comment(value={"After how many maximum ticks (20 ticks = 1 second) the wither will try to spawn Minions"})
                @Config.RangeInt(min=1, max=0x7FFFFFFF)
                public int maxCooldown = 300;
                @Config.Name(value="Min Armor")
                @Config.Comment(value={"Minimum armor value that Wither Minions should spawn with"})
                @Config.RangeInt(min=0, max=24)
                public int minArmor = 0;
                @Config.Name(value="Max Armor")
                @Config.Comment(value={"Maximum armor value that Wither Minions should spawn with"})
                @Config.RangeInt(min=0, max=20)
                public int maxArmor = 8;
            }

            public static class General {
                @Config.Name(value="Spawn Radius Players Check")
                @Config.Comment(value={"How much blocks from wither will be scanned for players to check for difficulty."})
                public int spawnRadiusPlayerCheck = 96;
                @Config.Name(value="Sum Spawned Wither Difficulty")
                @Config.Comment(value={"If true and there are more players around the Wither, the Wither will have his stats based on the sum of both players difficulty. If false, the Wither stats will be based on the average of the difficulty of the players around."})
                public boolean sumSpawnedWitherDifficulty = false;
                @Config.Name(value="Max Difficulty")
                @Config.Comment(value={"The Maximum difficulty (times spawned) reachable by Wither. By default is set to 72 because the Wither reaches the maximum amount of health (1024, handled by Minecraft. Some mods can increase this) after 72 withers spawned."})
                public int maxDifficulty = 72;
            }
        }
    }
}

