/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import java.util.UUID;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import oreexcavation.client.ExcavationKeys;
import oreexcavation.client.GuiEditShapes;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.groups.BlockBlacklist;
import oreexcavation.groups.BlockGroups;
import oreexcavation.groups.ItemBlacklist;
import oreexcavation.handlers.ConfigHandler;
import oreexcavation.handlers.MiningAgent;
import oreexcavation.handlers.MiningScheduler;
import oreexcavation.network.PacketExcavation;
import oreexcavation.overrides.ToolOverride;
import oreexcavation.overrides.ToolOverrideDefault;
import oreexcavation.overrides.ToolOverrideHandler;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.shapes.ShapeRegistry;
import oreexcavation.utils.ToolEffectiveCheck;
import org.lwjgl.input.Keyboard;

public class EventHandler {
    public static MiningAgent captureAgent;
    public static boolean skipNext;
    public static boolean isExcavating;
    private static int cTick;

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("oreexcavation")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyPressed(InputEvent event) {
        if (ExcavationKeys.shapeKey.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (Keyboard.isKeyDown((int)29)) {
                mc.func_147108_a((GuiScreen)new GuiEditShapes());
            } else {
                ShapeRegistry.INSTANCE.toggleShape();
                ExcavateShape shape = ShapeRegistry.INSTANCE.getActiveShape();
                if (shape == null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Excavate Shape: NONE"), false);
                } else {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Excavate Shape: " + shape.getName()), false);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K || event.getEntity().field_70128_L || event.isCanceled()) {
            return;
        }
        if (captureAgent != null) {
            if (event.getEntity() instanceof EntityItem) {
                EntityItem eItem = (EntityItem)event.getEntity();
                ItemStack stack = eItem.func_92059_d();
                captureAgent.addItemDrop(stack);
                event.setCanceled(true);
            } else if (event.getEntity() instanceof EntityXPOrb) {
                EntityXPOrb orb = (EntityXPOrb)event.getEntity();
                captureAgent.addExperience(orb.func_70526_d());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        MiningAgent agent;
        IStageData stage;
        if (event.getWorld().field_72995_K || event.isCanceled()) {
            return;
        }
        if (captureAgent != null && !captureAgent.hasMinedPosition(event.getPos())) {
            return;
        }
        if (!(event.getPlayer() instanceof EntityPlayerMP) || event.getPlayer() instanceof FakePlayer) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getPlayer();
        if (player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && !ExcavationSettings.openHand) {
            return;
        }
        if (EventHandler.isToolBlacklisted(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return;
        }
        if (EventHandler.isBlockBlacklisted(event.getState())) {
            return;
        }
        if (event.getState().func_177230_c().isAir(event.getState(), (IBlockAccess)event.getWorld(), event.getPos())) {
            return;
        }
        BlockPos p = event.getPos();
        IBlockState s = event.getState();
        if (ExcavationSettings.gamestagesInstalled && (stage = GameStageSaveHandler.getPlayerData((UUID)player.func_110124_au())) != null) {
            ToolOverride tover = ToolOverrideHandler.INSTANCE.getOverride(player.func_184586_b(EnumHand.MAIN_HAND));
            ToolOverride toolOverride = tover = tover != null ? tover : ToolOverrideDefault.DEFAULT;
            if (!StringUtils.func_151246_b((String)tover.getGameStage()) && !stage.hasStage(tover.getGameStage())) {
                return;
            }
            String blockStage = BlockGroups.INSTANCE.getStage(s);
            if (!StringUtils.func_151246_b((String)blockStage) && !stage.hasStage(blockStage)) {
                return;
            }
        }
        if ((ExcavationSettings.ignoreTools || ToolEffectiveCheck.canHarvestBlock(event.getWorld(), s, p, (EntityPlayer)player)) && (agent = MiningScheduler.INSTANCE.getActiveAgent(player.func_110124_au())) == null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a("pos", p.func_177986_g());
            tag.func_74768_a("stateId", Block.func_176210_f((IBlockState)s));
            tag.func_74768_a("side", ExcavateShape.getFacing((EntityPlayer)player, s, p).func_176745_a());
            OreExcavation.instance.network.sendTo((IMessage)new PacketExcavation(tag), player);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (skipNext) {
            skipNext = false;
            return;
        }
        MiningScheduler.INSTANCE.tickAgents(FMLCommonHandler.instance().getMinecraftServerInstance());
        captureAgent = null;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if ((cTick = (cTick + 1) % 10) != 0 || Minecraft.func_71410_x().field_71439_g == null || !isExcavating || !ExcavationSettings.mustHold) {
            return;
        }
        boolean canContinue = true;
        if (ExcavationSettings.mineMode < 0) {
            canContinue = false;
        } else if (ExcavationSettings.mineMode == 0) {
            if (!ExcavationKeys.excavateKey.func_151470_d()) {
                canContinue = false;
            }
        } else if (ExcavationSettings.mineMode != 2 && !Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            canContinue = false;
        }
        if (!canContinue) {
            isExcavating = false;
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74757_a("cancel", true);
            OreExcavation.instance.network.sendToServer((IMessage)new PacketExcavation(tags));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K || event.getWorld().func_73046_m().func_71278_l()) {
            return;
        }
        MiningScheduler.INSTANCE.resetAll();
        captureAgent = null;
    }

    public static boolean isBlockBlacklisted(IBlockState state) {
        if (state == null || state.func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        return BlockBlacklist.INSTANCE.isBanned(state) != ExcavationSettings.invertBBlacklist;
    }

    public static boolean isToolBlacklisted(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        return ItemBlacklist.INSTANCE.isBanned(stack) != ExcavationSettings.invertTBlacklist;
    }

    static {
        skipNext = false;
        isExcavating = false;
        cTick = 0;
    }
}

