/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Objects;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import openmods.api.IValueProvider;
import openmods.sync.SyncableObjectBase;

public class SyncableUUID
extends SyncableObjectBase
implements IValueProvider<UUID> {
    private UUID uuid;

    @Override
    public void readFromStream(PacketBuffer stream) {
        this.uuid = stream.readBoolean() ? stream.func_179253_g() : null;
    }

    @Override
    public void writeToStream(PacketBuffer stream) {
        if (this.uuid != null) {
            stream.writeBoolean(true);
            stream.func_179252_a(this.uuid);
        } else {
            stream.writeBoolean(false);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        if (this.uuid != null) {
            NBTTagCompound result = new NBTTagCompound();
            result.func_74772_a("MSB", this.uuid.getMostSignificantBits());
            result.func_74772_a("LSB", this.uuid.getLeastSignificantBits());
            nbt.func_74782_a(name, (NBTBase)result);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound data = nbt.func_74775_l(name);
            long msb = data.func_74763_f("MSB");
            long lsb = data.func_74763_f("LSB");
            this.uuid = new UUID(msb, lsb);
        } else {
            this.uuid = null;
        }
    }

    public void setValue(UUID value) {
        if (!Objects.equal((Object)this.uuid, (Object)value)) {
            this.uuid = value;
            this.markDirty();
        }
    }

    public void clear() {
        this.setValue(null);
    }

    @Override
    public UUID getValue() {
        return this.uuid;
    }
}

