/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColorChanger
extends ItemImpl
implements IColorProvidingItem {
    public ItemColorChanger() {
        super("color_changer");
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("naturesaura", "fill_mode"), (stack, worldIn, entityIn) -> ItemColorChanger.isFillMode(stack) ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("naturesaura", "has_color"), (stack, worldIn, entityIn) -> ItemColorChanger.getStoredColor(stack) != null ? 1.0f : 0.0f);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemColorChanger.changeOrCopyColor(player, stack, worldIn, pos, null)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private static boolean changeOrCopyColor(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumDyeColor firstColor) {
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (prop.func_177699_b() != EnumDyeColor.class) continue;
            EnumDyeColor color = (EnumDyeColor)state.func_177229_b(prop);
            if (firstColor != null && color != firstColor) continue;
            EnumDyeColor stored = ItemColorChanger.getStoredColor(stack);
            if (player.func_70093_af()) {
                if (stored == color) continue;
                world.func_184148_a(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187630_M, SoundCategory.PLAYERS, 0.65f, 1.0f);
                if (!world.field_72995_K) {
                    ItemColorChanger.storeColor(stack, color);
                }
                return true;
            }
            if (stored == null || stored == color || !NaturesAuraAPI.instance().extractAuraFromPlayer(player, 1000, world.field_72995_K)) continue;
            if (firstColor == null) {
                world.func_184148_a(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187624_K, SoundCategory.PLAYERS, 0.65f, 1.0f);
            }
            if (!world.field_72995_K) {
                world.func_175656_a(pos, state.func_177226_a(prop, (Comparable)stored));
                if (ItemColorChanger.isFillMode(stack)) {
                    for (EnumFacing off : EnumFacing.field_82609_l) {
                        ItemColorChanger.changeOrCopyColor(player, stack, world, pos.func_177972_a(off), color);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af() && ItemColorChanger.getStoredColor(stack) != null) {
            worldIn.func_184148_a(playerIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187633_N, SoundCategory.PLAYERS, 0.65f, 1.0f);
            if (!worldIn.field_72995_K) {
                ItemColorChanger.setFillMode(stack, !ItemColorChanger.isFillMode(stack));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private static EnumDyeColor getStoredColor(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        int color = stack.func_77978_p().func_74762_e("color");
        return EnumDyeColor.func_176764_b((int)color);
    }

    private static void storeColor(ItemStack stack, EnumDyeColor color) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("color", color.func_176765_a());
    }

    private static boolean isFillMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74767_n("fill");
    }

    private static void setFillMode(ItemStack stack, boolean fill) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("fill", fill);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return (stack, tintIndex) -> {
            EnumDyeColor color;
            if (tintIndex > 0 && (color = ItemColorChanger.getStoredColor(stack)) != null) {
                return color.func_193350_e();
            }
            return 0xFFFFFF;
        };
    }
}

