/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.chunk.ISpotDrainable;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ReplenishingEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "replenishing");

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (spot < 0) {
            ArrayList tiles = new ArrayList();
            Helper.getTileEntitiesInArea(world, pos, 25, tile -> {
                IAuraContainer container;
                if (tile.hasCapability(NaturesAuraAPI.capAuraContainer, null) && (container = (IAuraContainer)tile.getCapability(NaturesAuraAPI.capAuraContainer, null)) instanceof ISpotDrainable) {
                    tiles.add((ISpotDrainable)container);
                }
                return false;
            });
            if (!tiles.isEmpty()) {
                IAuraType type = IAuraType.forWorld(world);
                for (int i = world.field_73012_v.nextInt(6); i >= 0; --i) {
                    int drained;
                    ISpotDrainable tile2 = (ISpotDrainable)tiles.get(world.field_73012_v.nextInt(tiles.size()));
                    if (!tile2.isAcceptableType(type) || (drained = tile2.drainAuraPassively(-spot.intValue(), false)) <= 0) continue;
                    auraChunk.storeAura(pos, drained);
                    spot = spot + drained;
                    if (spot >= drained) break;
                }
            }
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return true;
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

