/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityPlacer
extends TileEntityImpl
implements ITickable {
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 15L == 0L) {
            if (this.redstonePower > 0) {
                return;
            }
            TileEntity tileUp = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
            if (tileUp == null || !tileUp.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
                return;
            }
            IItemHandler handler = (IItemHandler)tileUp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
            if (handler == null) {
                return;
            }
            List<EntityItemFrame> frames = Helper.getAttachedItemFrames(this.field_145850_b, this.field_174879_c);
            if (frames.isEmpty()) {
                return;
            }
            ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
            int range = 5;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos up;
                        IBlockState state;
                        BlockPos pos = this.field_174879_c.func_177982_a(x, y, z);
                        if (!this.framesContain(frames, pos, this.field_145850_b.func_180495_p(pos)) || !(state = this.field_145850_b.func_180495_p(up = pos.func_177984_a())).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, up)) continue;
                        validPositions.add(up);
                    }
                }
            }
            if (validPositions.isEmpty()) {
                return;
            }
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.extractItem(i, 1, true);
                if (stack.func_190926_b()) continue;
                BlockPos pos = (BlockPos)validPositions.get(this.field_145850_b.field_73012_v.nextInt(validPositions.size()));
                ItemStack left = this.tryPlace(stack.func_77946_l(), pos);
                if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)left)) continue;
                handler.extractItem(i, 1, false);
                BlockPos spot = IAuraChunk.getHighestSpot(this.field_145850_b, this.field_174879_c, 10, this.field_174879_c);
                IAuraChunk.getAuraChunk(this.field_145850_b, spot).drainAura(spot, 1000);
                PacketHandler.sendToAllAround(this.field_145850_b, this.field_174879_c, 32, new PacketParticles(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 9, new int[0]));
                return;
            }
        }
    }

    private boolean framesContain(List<EntityItemFrame> frames, BlockPos pos, IBlockState state) {
        ItemStack stack = state.func_177230_c().func_185473_a(this.field_145850_b, pos, state);
        if (stack.func_190926_b()) {
            return false;
        }
        for (EntityItemFrame frame : frames) {
            ItemStack frameStack = frame.func_82335_i();
            if (frameStack.func_190926_b()) continue;
            if (Helper.areItemsEqual(stack, frameStack, false)) {
                return true;
            }
            if (state.func_177230_c() != Blocks.field_150458_ak || frameStack.func_77973_b() != ModItems.FARMING_STENCIL) continue;
            return true;
        }
        return false;
    }

    private ItemStack tryPlace(ItemStack stack, BlockPos pos) {
        if (this.handleSpecialCases(stack, pos)) {
            return stack;
        }
        if (!(this.field_145850_b instanceof WorldServer)) {
            return stack;
        }
        FakePlayer fake = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_145850_b));
        fake.field_71071_by.field_70462_a.set(fake.field_71071_by.field_70461_c, (Object)stack);
        fake.field_71134_c.func_187251_a((EntityPlayer)fake, this.field_145850_b, fake.func_184614_ca(), EnumHand.MAIN_HAND, pos, EnumFacing.DOWN, 0.5f, 0.5f, 0.5f);
        return fake.func_184614_ca().func_77946_l();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleSpecialCases(ItemStack stack, BlockPos pos) {
        if (stack.func_77973_b() == Items.field_151137_ax) {
            if (!Blocks.field_150488_af.func_176196_c(this.field_145850_b, pos)) return false;
            this.field_145850_b.func_175656_a(pos, Blocks.field_150488_af.func_176223_P());
        } else if (stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.GOLD_POWDER)) {
            if (!ModBlocks.GOLD_POWDER.func_176196_c(this.field_145850_b, pos)) return false;
            this.field_145850_b.func_175656_a(pos, ModBlocks.GOLD_POWDER.func_176223_P());
        } else {
            if (!(stack.func_77973_b() instanceof IPlantable)) return false;
            IPlantable plantable = (IPlantable)stack.func_77973_b();
            IBlockState plant = plantable.getPlant((IBlockAccess)this.field_145850_b, pos);
            if (!plant.func_177230_c().func_176196_c(this.field_145850_b, pos)) {
                return false;
            }
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            if (!state.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, pos)) {
                return false;
            }
            this.field_145850_b.func_175656_a(pos, plant);
        }
        stack.func_190918_g(1);
        return true;
    }
}

