/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityImpl
extends TileEntity {
    public int redstonePower;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeNBT(compound, SaveType.TILE);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.readNBT(compound, SaveType.TILE);
    }

    public void writeNBT(NBTTagCompound compound, SaveType type) {
        if (type != SaveType.BLOCK) {
            super.func_189515_b(compound);
            compound.func_74768_a("redstone", this.redstonePower);
        }
    }

    public void readNBT(NBTTagCompound compound, SaveType type) {
        if (type != SaveType.BLOCK) {
            super.func_145839_a(compound);
            this.redstonePower = compound.func_74762_e("redstone");
        }
    }

    public void onRedstonePowerChange(int newPower) {
        this.redstonePower = newPower;
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeNBT(compound, SaveType.SYNC);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public final NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeNBT(compound, SaveType.SYNC);
        return compound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readNBT(tag, SaveType.SYNC);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readNBT(packet.func_148857_g(), SaveType.SYNC);
    }

    public void sendToClients() {
        WorldServer world = (WorldServer)this.func_145831_w();
        PlayerChunkMapEntry entry = world.func_184164_w().func_187301_b(this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4);
        if (entry != null) {
            entry.func_187267_a((Packet)this.func_189518_D_());
        }
    }

    public IItemHandlerModifiable getItemHandler(EnumFacing facing) {
        return null;
    }

    public IAuraContainer getAuraContainer(EnumFacing facing) {
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getItemHandler(facing) != null;
        }
        if (capability == NaturesAuraAPI.capAuraContainer) {
            return this.getAuraContainer(facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.getItemHandler(facing);
        }
        if (capability == NaturesAuraAPI.capAuraContainer) {
            return (T)this.getAuraContainer(facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void dropInventory() {
        IItemHandlerModifiable handler = this.getItemHandler(null);
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
                this.field_145850_b.func_72838_d((Entity)item);
            }
        }
    }

    public ItemStack getDrop(IBlockState state, int fortune) {
        Block block = state.func_177230_c();
        ItemStack stack = new ItemStack(block.func_180660_a(state, this.field_145850_b.field_73012_v, fortune), block.quantityDropped(state, fortune, this.field_145850_b.field_73012_v), block.func_180651_a(state));
        NBTTagCompound compound = new NBTTagCompound();
        this.writeNBT(compound, SaveType.BLOCK);
        if (!compound.func_82582_d()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74782_a("data", (NBTBase)compound);
        }
        return stack;
    }

    public void loadDataOnPlace(ItemStack stack) {
        NBTTagCompound compound;
        if (stack.func_77942_o() && (compound = stack.func_77978_p().func_74775_l("data")) != null) {
            this.readNBT(compound, SaveType.BLOCK);
        }
    }

    public boolean canGenerateRightNow(int range, int toAdd) {
        IBlockState below;
        if (this.wantsLimitRemover() && (below = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())).func_177230_c() == ModBlocks.GENERATOR_LIMIT_REMOVER) {
            return true;
        }
        int aura = IAuraChunk.getAuraInArea(this.field_145850_b, this.field_174879_c, range);
        return aura + toAdd <= 2000000;
    }

    public boolean wantsLimitRemover() {
        return false;
    }

    public static enum SaveType {
        TILE,
        SYNC,
        BLOCK;

    }
}

