/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import java.util.HashSet;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TileEntityChunkLoader
extends TileEntityImpl
implements ITickable {
    private ForgeChunkManager.Ticket ticket;

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K && this.ticket == null) {
            ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)NaturesAura.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            this.updateTicket(ticket);
            ticket.getModData().func_74772_a("pos", this.field_174879_c.func_177986_g());
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.updateTicket(null);
        }
    }

    @Override
    public void onRedstonePowerChange(int newPower) {
        super.onRedstonePowerChange(newPower);
        if (!this.field_145850_b.field_72995_K) {
            this.loadChunks();
            this.sendToClients();
        }
    }

    public int range() {
        return this.redstonePower * 2;
    }

    public void updateTicket(ForgeChunkManager.Ticket ticket) {
        if (this.ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
        this.ticket = ticket;
    }

    public void loadChunks() {
        if (this.ticket == null) {
            return;
        }
        HashSet before = new HashSet(this.ticket.getChunkList());
        int range = this.range();
        if (range > 0) {
            for (int x = this.field_174879_c.func_177958_n() - range >> 4; x <= this.field_174879_c.func_177958_n() + range >> 4; ++x) {
                for (int z = this.field_174879_c.func_177952_p() - range >> 4; z <= this.field_174879_c.func_177952_p() + range >> 4; ++z) {
                    ChunkPos pos = new ChunkPos(x, z);
                    if (!before.contains(pos)) {
                        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)pos);
                        continue;
                    }
                    before.remove(pos);
                }
            }
        }
        for (ChunkPos pos : before) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)pos);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L != 0L) {
                return;
            }
            int toUse = MathHelper.func_76123_f((float)((float)this.range() / 2.0f));
            if (toUse > 0) {
                BlockPos spot = IAuraChunk.getHighestSpot(this.field_145850_b, this.field_174879_c, 35, this.field_174879_c);
                IAuraChunk.getAuraChunk(this.field_145850_b, spot).drainAura(spot, toUse);
            }
        }
    }
}

