/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.api.aura.type;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class BasicAuraType
implements IAuraType {
    private final ResourceLocation name;
    private final int color;
    private final int priority;
    private final Set<DimensionType> dimensions = new HashSet<DimensionType>();

    public BasicAuraType(ResourceLocation name, DimensionType dimension, int color, int priority) {
        this.name = name;
        this.color = color;
        this.priority = priority;
        if (dimension != null) {
            this.dimensions.add(dimension);
        }
    }

    public BasicAuraType register() {
        NaturesAuraAPI.AURA_TYPES.put(this.name, this);
        return this;
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public boolean isPresentInWorld(World world) {
        return this.dimensions.isEmpty() || this.dimensions.contains(world.field_73011_w.func_186058_p());
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void addDimensionType(DimensionType type) {
        this.dimensions.add(type);
    }
}

