/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.morphspellpack.spell;

import com.windanesz.morphspellpack.items.ItemSoulPhylactery;
import com.windanesz.morphspellpack.registry.MSItems;
import com.windanesz.morphspellpack.spell.SpellTransformation;
import com.windanesz.wizardryutils.integration.baubles.BaublesIntegration;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class SoulTransformation
extends Spell {
    private static final String SOUL_COST = "soul_cost";

    public SoulTransformation() {
        super("morphspellpack", "soul_transformation", SpellActions.SUMMON, false);
        this.addProperties(new String[]{"duration", SOUL_COST});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)MSItems.charm_soul_phylactery)) {
            int duration = (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
            ItemStack stack = (ItemStack)BaublesIntegration.getEquippedArtefactStacks((EntityPlayer)caster, (Object[])new Object[]{ItemArtefact.Type.CHARM}).get(0);
            if (ItemSoulPhylactery.hasEntity(stack)) {
                if (ItemSoulPhylactery.getPercentFilled(stack) >= this.getProperty(SOUL_COST).floatValue()) {
                    boolean flag = SpellTransformation.morphPlayer((EntityLivingBase)caster, ItemSoulPhylactery.getEntity(stack), duration);
                    if (flag) {
                        ItemStack stack1 = ItemSoulPhylactery.consumePercent(stack, this.getProperty(SOUL_COST).floatValue());
                        BaublesIntegration.setArtefactToSlot((EntityPlayer)caster, (ItemStack)stack1, (ItemArtefact.Type)ItemArtefact.Type.CHARM);
                    }
                    return flag;
                }
                if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.morphspellpack:soul_transformation.phylactery_no_charge", new Object[0]), false);
                }
            } else if (!world.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.morphspellpack:soul_transformation.phylactery_no_entity", new Object[0]), false);
            }
        } else if (!world.field_72995_K) {
            caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.morphspellpack:soul_transformation.no_phylactery", new Object[0]), false);
        }
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }
}

