/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.morphspellpack.spell;

import com.windanesz.morphspellpack.Settings;
import com.windanesz.morphspellpack.Utils;
import com.windanesz.morphspellpack.spell.SpellTransformation;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Skinchanger
extends SpellRay {
    public static final String MAX_MOB_HP = "max_mob_hp";

    public Skinchanger() {
        super("morphspellpack", "skinchanger", SpellActions.POINT, false);
        this.addProperties(new String[]{"duration", MAX_MOB_HP});
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer && !world.field_72995_K && target instanceof EntityLivingBase) {
            EntityLivingBase livingTarget = (EntityLivingBase)target;
            int maxAllowedHP = this.getProperty(MAX_MOB_HP).intValue();
            if (livingTarget.func_110138_aP() >= (float)maxAllowedHP) {
                Utils.sendMessage((Entity)caster, "spell.morphspellpack:skinchanger.mob_too_strong", true, new Object[0]);
                return false;
            }
            String entity = EntityList.func_191301_a((Entity)livingTarget).toString();
            List<String> bannedMobs = Arrays.asList(Settings.generalSettings.skinchanger_banned_mobs);
            if (bannedMobs.contains(entity)) {
                Utils.sendMessage((Entity)caster, "spell.morphspellpack:skinchanger.mob_not_allowed", true, new Object[0]);
                return false;
            }
            if (Settings.generalSettings.skinchanger_disallow_undeads && (livingTarget.func_70644_a(WizardryPotions.curse_of_undeath) || livingTarget.func_70662_br())) {
                Utils.sendMessage((Entity)caster, "spell.morphspellpack:skinchanger.undead_not_allowed", true, new Object[0]);
                return false;
            }
            int duration = this.getProperty("duration").intValue();
            SpellTransformation.morphPlayer(caster, entity, duration);
            return true;
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }
}

