/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.morphspellpack.handler;

import com.windanesz.morphspellpack.spell.SpellTransformation;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class LichHandler {
    public static final String LICH = "morphspellpack:lich";
    public static final IStoredVariable<Boolean> IS_LICH = IStoredVariable.StoredVariable.ofBoolean((String)"isLich", (Persistence)Persistence.ALWAYS).setSynced();

    private LichHandler() {
    }

    public static void init() {
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{IS_LICH});
    }

    public static boolean isLich(Entity player) {
        WizardData data;
        if (player instanceof EntityPlayer && (data = WizardData.get((EntityPlayer)((EntityPlayer)player))) != null) {
            Boolean lich = (Boolean)data.getVariable(IS_LICH);
            return lich != null && lich != false;
        }
        return false;
    }

    public static void setLich(Entity player, boolean lich) {
        WizardData data;
        if (player instanceof EntityPlayer && (data = WizardData.get((EntityPlayer)((EntityPlayer)player))) != null) {
            data.setVariable(IS_LICH, (Object)lich);
            data.sync();
        }
    }

    @SubscribeEvent
    public static void onInteractItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().func_77975_n() == EnumAction.EAT && LichHandler.isLich((Entity)event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().field_70170_p.func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150414_aQ && LichHandler.isLich(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && LichHandler.isLich(event.getEntity())) {
            SpellTransformation.morphPlayer((EntityLivingBase)((EntityPlayer)event.getEntity()), LICH, -1);
        }
    }
}

