/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.morphspellpack.ability.active;

import com.windanesz.morphspellpack.ability.IActiveAbility;
import electroblob.wizardry.item.ItemArtefact;
import me.ichun.mods.morph.api.ability.Ability;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AbilityTimedPotionFromArtefact
extends Ability
implements IActiveAbility {
    public static final String name = "timedPotionWithArtefact";
    private String potionName;
    public Boolean toggled;
    public int cooldown = 0;
    public int maxCooldown = 0;
    public int effectDuration = 0;
    Potion potion;
    private Item artefact;

    public AbilityTimedPotionFromArtefact() {
    }

    public AbilityTimedPotionFromArtefact(String potion, int maxCooldown, int effectDuration, Item artefact) {
        this.potionName = potion;
        this.maxCooldown = maxCooldown;
        this.effectDuration = effectDuration;
        this.potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potion));
        this.artefact = artefact;
    }

    public Ability parse(String[] args) {
        this.potionName = args[0];
        this.maxCooldown = Integer.parseInt(args[1]);
        this.effectDuration = Integer.parseInt(args[2]);
        this.artefact = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(args[3]));
        return this;
    }

    public Ability clone() {
        return new AbilityTimedPotionFromArtefact(this.potionName, this.maxCooldown, this.effectDuration, this.artefact);
    }

    public String getType() {
        return name;
    }

    public void tick() {
        if (this.cooldown > 0) {
            --this.cooldown;
            this.toggled = false;
        }
        if (this.toggled != null && this.toggled.booleanValue() && this.conditionPredicate() && this.potion != null && this.getParent() instanceof EntityPlayerMP) {
            EntityPlayerMP caster = (EntityPlayerMP)this.getParent();
            caster.func_70690_d(new PotionEffect(this.potion, this.effectDuration));
        }
        this.toggled = false;
    }

    @Override
    public void toggleAbility() {
        this.toggled = true;
    }

    @Override
    public boolean conditionPredicate() {
        return this.getParent() instanceof EntityPlayer && this.artefact != null && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)this.getParent()), (Item)this.artefact);
    }
}

