/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.morphspellpack.ability.active;

import com.windanesz.morphspellpack.ability.IActiveAbility;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import me.ichun.mods.morph.api.ability.Ability;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AbilitySpell
extends Ability
implements IActiveAbility {
    public static final String name = "spellCast";
    public Boolean castingToggled;
    public Spell spell = Spells.none;
    public int cooldown = 0;
    public int maxCooldown = 0;

    public AbilitySpell() {
    }

    public AbilitySpell(Spell spell, int maxCooldown) {
        this.spell = spell;
        this.maxCooldown = maxCooldown;
    }

    public Ability parse(String[] args) {
        this.spell = Spell.get((String)args[0]);
        this.maxCooldown = Integer.parseInt(args[1]);
        return this;
    }

    public Ability clone() {
        return new AbilitySpell(this.spell, this.maxCooldown);
    }

    public String getType() {
        return name;
    }

    public void tick() {
        if (this.cooldown > 0) {
            --this.cooldown;
            this.castingToggled = false;
        }
        if (this.castingToggled != null && this.castingToggled.booleanValue() && this.conditionPredicate() && this.getParent() instanceof EntityPlayerMP) {
            EntityPlayerMP caster = (EntityPlayerMP)this.getParent();
            if (this.spell.isContinuous) {
                WizardData data = WizardData.get((EntityPlayer)caster);
                if (data != null) {
                    if (data.isCasting()) {
                        data.stopCastingContinuousSpell();
                    } else {
                        SpellModifiers modifiers = new SpellModifiers();
                        int duration = 60;
                        data.startCastingContinuousSpell(this.spell, modifiers, duration);
                        this.cooldown = this.maxCooldown;
                    }
                }
            } else {
                SpellModifiers modifiers = new SpellModifiers();
                if (this.spell.cast(caster.field_70170_p, (EntityPlayer)caster, EnumHand.MAIN_HAND, 0, modifiers)) {
                    MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.COMMAND, this.spell, (EntityLivingBase)caster, modifiers));
                    this.cooldown = this.maxCooldown;
                    if (this.spell.requiresPacket()) {
                        PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), null, this.spell, modifiers);
                        WizardryPacketHandler.net.sendToDimension((IMessage)msg, caster.field_70170_p.field_73011_w.getDimension());
                    }
                }
            }
        }
        this.castingToggled = false;
    }

    public void setSpell(Spell spell) {
        this.spell = spell;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public void toggleAbility() {
        this.castingToggled = true;
    }
}

