/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.ability.type;

import java.util.ArrayList;
import me.ichun.mods.morph.api.ability.Ability;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilitySwim
extends Ability {
    public boolean canSurviveOutOfWater = false;
    public int air = 8008135;
    public float swimSpeed = 1.0f;
    public float landSpeed = 1.0f;
    public boolean canMaintainDepth = false;
    public static final ResourceLocation iconResource = new ResourceLocation("morph", "textures/icon/swim.png");

    public AbilitySwim() {
    }

    public AbilitySwim(boolean airBreather) {
        this();
        this.canSurviveOutOfWater = airBreather;
    }

    public AbilitySwim(boolean airBreather, float swimModifier, float landModifier, boolean maintainDepth) {
        this(airBreather);
        this.swimSpeed = swimModifier;
        this.landSpeed = landModifier;
        this.canMaintainDepth = maintainDepth;
        if (this.swimSpeed > 1.22f) {
            this.swimSpeed = 1.22f;
        }
    }

    @Override
    public Ability parse(String[] args) {
        this.canSurviveOutOfWater = Boolean.parseBoolean(args[0]);
        this.swimSpeed = Float.parseFloat(args[1]);
        this.landSpeed = Float.parseFloat(args[2]);
        this.canMaintainDepth = Boolean.parseBoolean(args[3]);
        if (this.swimSpeed > 1.22f) {
            this.swimSpeed = 1.22f;
        }
        return this;
    }

    @Override
    public String getType() {
        return "swim";
    }

    @Override
    public void tick() {
        if (this.air == 8008135) {
            this.air = this.getParent().func_70086_ai();
        }
        if (this.getParent().func_70090_H()) {
            if (this.getParent().func_130014_f_().field_72995_K && GuiIngameForge.renderAir) {
                GuiIngameForge.renderAir = false;
            }
            this.getParent().func_70050_g(300);
            this.air = 300;
            if (!(this.swimSpeed == 1.0f || this.getParent() instanceof EntityPlayer && ((EntityPlayer)this.getParent()).field_71075_bZ.field_75100_b)) {
                if (this.getParent().field_70159_w > (double)(-this.swimSpeed) && this.getParent().field_70159_w < (double)this.swimSpeed) {
                    this.getParent().field_70159_w *= (double)(this.swimSpeed * 0.995f);
                }
                if (this.getParent().field_70179_y > (double)(-this.swimSpeed) && this.getParent().field_70179_y < (double)this.swimSpeed) {
                    this.getParent().field_70179_y *= (double)(this.swimSpeed * 0.995f);
                }
            }
            if (this.canMaintainDepth) {
                boolean isJumping = this.getParent().field_70703_bu;
                if (!this.getParent().func_70093_af() && !isJumping && this.getParent().func_70055_a(Material.field_151586_h)) {
                    this.getParent().field_70181_x = 0.0;
                } else if (isJumping) {
                    this.getParent().field_70181_x *= (double)this.swimSpeed;
                }
            }
        } else if (!this.canSurviveOutOfWater) {
            int j = EnchantmentHelper.func_185292_c((EntityLivingBase)this.getParent());
            int n = this.air = j > 0 && this.getParent().func_70681_au().nextInt(j + 1) > 0 ? this.air : this.air - 1;
            if (this.air == -20) {
                this.air = 0;
                this.getParent().func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
            if (!(this.getParent() instanceof EntityPlayer && ((EntityPlayer)this.getParent()).field_71075_bZ.field_75100_b || this.landSpeed == 1.0f || this.air >= 285)) {
                if (this.getParent().field_70159_w > (double)(-this.landSpeed) && this.getParent().field_70159_w < (double)this.landSpeed) {
                    this.getParent().field_70159_w *= (double)this.landSpeed;
                }
                if (this.getParent().field_70179_y > (double)(-this.landSpeed) && this.getParent().field_70179_y < (double)this.landSpeed) {
                    this.getParent().field_70179_y *= (double)this.landSpeed;
                }
            }
        }
    }

    @Override
    public void kill(ArrayList<Ability> nextAbilities) {
        if (this.getParent() != null && this.getParent().func_130014_f_().field_72995_K && !GuiIngameForge.renderAir) {
            GuiIngameForge.renderAir = true;
        }
    }

    @Override
    public Ability clone() {
        return new AbilitySwim(this.canSurviveOutOfWater, this.swimSpeed, this.landSpeed, this.canMaintainDepth);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postRender() {
        if (!this.canSurviveOutOfWater) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r == null && mc.field_71439_g == this.getParent() && !mc.field_71439_g.func_70055_a(Material.field_151586_h) && !mc.field_71439_g.field_71075_bZ.field_75102_a) {
                mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                ScaledResolution scaledresolution = new ScaledResolution(mc);
                int width = scaledresolution.func_78326_a();
                int height = scaledresolution.func_78328_b();
                int l1 = width / 2 + 91;
                int i2 = height - 39;
                IAttributeInstance attributeinstance = mc.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111267_a);
                float f = (float)attributeinstance.func_111126_e();
                float f1 = mc.field_71439_g.func_110139_bj();
                int j2 = MathHelper.func_76123_f((float)((f + f1) / 2.0f / 10.0f));
                int k2 = Math.max(10 - (j2 - 2), 3);
                int l2 = i2 - (j2 - 1) * k2 - 10;
                int k3 = this.air;
                int l4 = MathHelper.func_76143_f((double)((double)(this.air - 2) * 10.0 / 300.0));
                int i4 = MathHelper.func_76143_f((double)((double)this.air * 10.0 / 300.0)) - l4;
                for (int k4 = 0; k4 < l4 + i4; ++k4) {
                    if (k4 < l4) {
                        this.drawTexturedModalRect(l1 - k4 * 8 - 9, l2, 16, 18, 9, 9);
                        continue;
                    }
                    this.drawTexturedModalRect(l1 - k4 * 8 - 9, l2, 25, 18, 9, 9);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)par1, (double)(par2 + par6), 0.0).func_187315_a((double)((float)par3 * f), (double)((float)(par4 + par6) * f1)).func_181675_d();
        bufferBuilder.func_181662_b((double)(par1 + par5), (double)(par2 + par6), 0.0).func_187315_a((double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1)).func_181675_d();
        bufferBuilder.func_181662_b((double)(par1 + par5), (double)par2, 0.0).func_187315_a((double)((float)(par3 + par5) * f), (double)((float)par4 * f1)).func_181675_d();
        bufferBuilder.func_181662_b((double)par1, (double)par2, 0.0).func_187315_a((double)((float)par3 * f), (double)((float)par4 * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getIcon() {
        return iconResource;
    }
}

