/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.utils.nbt;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.machinemuse.numina.client.render.modelspec.ModelRegistry;
import net.machinemuse.numina.client.render.modelspec.TexturePartSpec;
import net.machinemuse.numina.nbt.MuseNBTUtils;
import net.machinemuse.powersuits.client.render.modelspec.DefaultModelSpec;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.item.armor.ItemPowerArmor;
import net.machinemuse.powersuits.item.tool.ItemPowerFist;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MPSNBTUtils {
    public static NBTTagCompound getMuseRenderTag(@Nonnull ItemStack stack, EntityEquipmentSlot armorSlot) {
        NBTTagCompound renderTag;
        NBTTagCompound itemTag;
        block8: {
            block7: {
                itemTag = MuseNBTUtils.getMuseItemTag((ItemStack)stack);
                renderTag = new NBTTagCompound();
                if (itemTag.func_150297_b("render", 10)) {
                    renderTag = itemTag.func_74775_l("render");
                } else if (itemTag.func_150297_b("cosmeticPreset", 8)) {
                    renderTag = MPSConfig.getPresetNBTFor(stack, itemTag.func_74779_i("cosmeticPreset"));
                }
                if (renderTag != null && !renderTag.func_82582_d()) {
                    return renderTag;
                }
                if (!MPSConfig.INSTANCE.useLegacyCosmeticSystem()) break block7;
                if (!(stack.func_77973_b() instanceof ItemPowerFist)) break block8;
                if (!MPSConfig.INSTANCE.allowPowerFistCustomization()) break block8;
            }
            itemTag.func_74778_a("cosmeticPreset", "Default");
            return MPSConfig.getPresetNBTFor(stack, "Default");
        }
        renderTag = DefaultModelSpec.makeModelPrefs(stack, armorSlot);
        itemTag.func_74782_a("render", (NBTBase)renderTag);
        return renderTag;
    }

    public static NBTTagCompound getMuseRenderTag(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ItemPowerArmor) {
                return MPSNBTUtils.getMuseRenderTag(stack, ((ItemPowerArmor)stack.func_77973_b()).field_77881_a);
            }
            if (stack.func_77973_b() instanceof ItemPowerFist) {
                return MPSNBTUtils.getMuseRenderTag(stack, EntityEquipmentSlot.MAINHAND);
            }
        }
        return new NBTTagCompound();
    }

    public static String getArmorTexture(ItemStack stack, EntityEquipmentSlot slot) {
        NBTTagCompound renderTag = MPSNBTUtils.getMuseRenderTag(stack, slot);
        try {
            TexturePartSpec partSpec = (TexturePartSpec)ModelRegistry.getInstance().getPart(renderTag.func_74775_l("texSpec"));
            return partSpec.getTextureLocation();
        }
        catch (Exception ignored) {
            return "powersuits:textures/items/armor/blankarmor.png";
        }
    }

    public static boolean hasHighPolyModel(ItemStack stack, EntityEquipmentSlot slot) {
        NBTTagCompound renderTag = MPSNBTUtils.getMuseRenderTag(stack, slot);
        for (String tagName : renderTag.func_150296_c()) {
            if (Objects.equals(tagName, "texSpec") || Objects.equals(tagName, "colours")) continue;
            return true;
        }
        return false;
    }
}

