/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.mospells.spell;

import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.client.particles.ParticleCloud;
import com.windanesz.mospells.registry.MSItems;
import com.windanesz.mospells.registry.MSSpells;
import com.windanesz.mospells.util.Utils;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WindsOfWinter
extends Spell {
    public WindsOfWinter() {
        super("mospells", "winds_of_winter", SpellActions.POINT, true);
        this.addProperties(new String[]{"damage"});
    }

    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    public void playWindSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSound(world, entity, ticksInUse, duration, modifiers, sounds);
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return WindsOfWinter.castWind(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return WindsOfWinter.castWind(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    public static boolean castWind(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean hasCharm = caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)MSItems.charm_cold_winds);
        ((WindsOfWinter)MSSpells.winds_of_winter).playWindSound(world, caster, ticksInUse, -1, new SpellModifiers(), new String[0]);
        if (hasCharm && caster.func_70027_ad()) {
            caster.func_70066_B();
        }
        List entities = EntityUtils.getEntitiesWithinRadius((double)5.0, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class);
        if (hasCharm && !world.field_72995_K) {
            List nearbyBlocks = BlockUtils.getBlockSphere((BlockPos)caster.func_180425_c(), (double)5.0);
            Iterator iterator = nearbyBlocks.iterator();
            while (iterator.hasNext()) {
                BlockPos currPos = (BlockPos)iterator.next();
                if (world.func_180495_p(currPos).func_177230_c() != Blocks.field_150480_ab || !BlockUtils.canBreakBlock((Entity)caster, (World)world, (BlockPos)currPos)) continue;
                world.func_175698_g(currPos);
                world.func_184133_a(null, currPos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.7f, 1.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
            }
        }
        for (EntityLivingBase target : entities) {
            if (target == caster || AllyDesignationSystem.isAllied((EntityLivingBase)caster, (EntityLivingBase)target)) continue;
            if (hasCharm && !world.field_72995_K) {
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FROST), (float)1.5f);
                if (target.func_70027_ad()) {
                    target.func_70066_B();
                }
            }
            target.func_70690_d(new PotionEffect(WizardryPotions.frost, 40, 0));
            double angle = (Utils.getAngleBetweenEntities((Entity)caster, (Entity)target) + 90.0) * Math.PI / 180.0;
            double distance = caster.func_70032_d((Entity)target) - 4.0f;
            target.field_70159_w += Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.cos(angle);
            target.field_70179_y += Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.sin(angle);
        }
        if (ticksInUse == -1 || ticksInUse % 12 == 0 && world.field_72995_K) {
            double zSpeed;
            double xSpeed;
            double speed;
            int i;
            int particleCount = 15;
            for (i = 1; i <= particleCount; ++i) {
                double yaw = i * 360 / particleCount;
                speed = 0.9;
                xSpeed = speed * Math.cos(Math.toRadians(yaw));
                zSpeed = speed * Math.sin(Math.toRadians(yaw));
                MMParticle.CLOUD.spawn(world, caster.field_70165_t, caster.field_70163_u + 1.0, caster.field_70161_v, ParticleFactory.ParticleArgs.get().withData(new Object[]{xSpeed, 0.0, zSpeed, 0.75, 0.75, 1.0, 1, 40.0, 22, ParticleCloud.EnumCloudBehavior.GROW}));
            }
            for (i = 1; i <= particleCount; ++i) {
                double yaw = i * 360 / particleCount;
                speed = 0.65;
                xSpeed = speed * Math.cos(Math.toRadians(yaw));
                zSpeed = speed * Math.sin(Math.toRadians(yaw));
                MMParticle.CLOUD.spawn(world, caster.field_70165_t, caster.field_70163_u + 1.0, caster.field_70161_v, ParticleFactory.ParticleArgs.get().withData(new Object[]{xSpeed, 0.0, zSpeed, 0.75, 0.75, 1.0, 1, 35.0, 22, ParticleCloud.EnumCloudBehavior.GROW}));
            }
        }
        return true;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == MSItems.mospells_spell_book || item == MSItems.mospells_scroll;
    }
}

