/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.mospells.spell;

import com.windanesz.mospells.entity.EntityFrostmawMinion;
import com.windanesz.mospells.registry.MSItems;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.spell.SpellMinion;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class SummonFrostmaw
extends SpellMinion<EntityFrostmawMinion> {
    public static final IStoredVariable<Integer> SUMMON_FROSTMAW_LAST_USAGE_DAY = IStoredVariable.StoredVariable.ofInt((String)"summonFrostmawLastUsageDay", (Persistence)Persistence.ALWAYS);

    public SummonFrostmaw() {
        super("mospells", "summon_frostmaw", EntityFrostmawMinion::new);
        this.soundValues(1.0f, 1.1f, 0.1f);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{SUMMON_FROSTMAW_LAST_USAGE_DAY});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!(caster.func_184586_b(hand).func_77973_b() instanceof ItemWand) || ((ItemWand)caster.func_184586_b((EnumHand)hand).func_77973_b()).element != Element.ICE) {
            if (!world.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".non_ice_wand", new Object[0]), true);
            }
            return false;
        }
        if (this.canUseToday(caster)) {
            if (super.cast(world, caster, hand, ticksInUse, modifiers)) {
                this.updateUsageData(caster);
                return true;
            }
        } else if (!world.field_72995_K) {
            caster.func_146105_b((ITextComponent)new TextComponentTranslation("cannot_use_spell_again_today", new Object[0]), true);
        }
        return false;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        return false;
    }

    public void updateUsageData(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            int today = (int)(player.field_70170_p.func_72820_D() / 24000L % Integer.MAX_VALUE);
            data.setVariable(SUMMON_FROSTMAW_LAST_USAGE_DAY, (Object)today);
        }
    }

    public boolean canUseToday(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            Integer lastUse = (Integer)data.getVariable(SUMMON_FROSTMAW_LAST_USAGE_DAY);
            if (lastUse == null) {
                return true;
            }
            int today = (int)(player.field_70170_p.func_72820_D() / 24000L % Integer.MAX_VALUE);
            return lastUse != today;
        }
        return true;
    }

    protected void addMinionExtras(EntityFrostmawMinion minion, BlockPos pos, @Nullable EntityLivingBase caster, SpellModifiers modifiers, int alreadySpawned) {
        if (!minion.field_70170_p.field_72995_K) {
            minion.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 6000, 1));
        }
    }

    public boolean applicableForItem(Item item) {
        return item == MSItems.mospells_spell_book || item == MSItems.mospells_scroll;
    }
}

