/*
 * Decompiled with CFR 0.152.
 */
package magicbees.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IAllele;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import magicbees.bees.EnumBeeSpecies;
import magicbees.elec332.corerepack.compat.forestry.ForestryAlleles;
import org.apache.commons.lang3.tuple.Pair;

public class WorldGenBeeSpeciesCache {
    private static List<Pair<IAlleleBeeSpecies, Double>> worldgenSpeciesWeights = Lists.newArrayList();
    private static double worldgenSpeciesWeightsTotal = 0.0;

    public static IBee getRandomWorldgenSpecies(Random r, boolean rainResist) {
        Collections.shuffle(worldgenSpeciesWeights);
        double value = r.nextDouble() * worldgenSpeciesWeightsTotal;
        IAlleleBeeSpecies species = (IAlleleBeeSpecies)worldgenSpeciesWeights.get(0).getLeft();
        for (Pair<IAlleleBeeSpecies, Double> t : worldgenSpeciesWeights) {
            if (!((value -= ((Double)t.getRight()).doubleValue()) <= 0.0)) continue;
            species = (IAlleleBeeSpecies)t.getLeft();
            break;
        }
        IAllele[] allelez = BeeManager.beeRoot.getTemplate(species.getUID());
        Preconditions.checkNotNull((Object)allelez);
        IAllele[] alleles = Arrays.copyOf(allelez, allelez.length);
        if (rainResist) {
            alleles[EnumBeeChromosome.TOLERATES_RAIN.ordinal()] = ForestryAlleles.TRUE_RECESSIVE;
        }
        return BeeManager.beeRoot.getBee(BeeManager.beeRoot.templateAsGenome(alleles));
    }

    public static void addWorldgenSpeciesWeight(IAlleleBeeSpecies species, double d) {
        Preconditions.checkNotNull((Object)species);
        Preconditions.checkArgument((d > 0.0 ? 1 : 0) != 0);
        worldgenSpeciesWeights.add((Pair<IAlleleBeeSpecies, Double>)Pair.of((Object)species, (Object)d));
        worldgenSpeciesWeightsTotal += d;
    }

    public static void populateSpeciesListRarity() {
        WorldGenBeeSpeciesCache.addWorldgenSpeciesWeight(EnumBeeSpecies.getForestrySpecies("Forest"), 20.0);
        WorldGenBeeSpeciesCache.addWorldgenSpeciesWeight(EnumBeeSpecies.getForestrySpecies("Meadows"), 20.0);
        WorldGenBeeSpeciesCache.addWorldgenSpeciesWeight(EnumBeeSpecies.getForestrySpecies("Tropical"), 10.0);
        WorldGenBeeSpeciesCache.addWorldgenSpeciesWeight(EnumBeeSpecies.getForestrySpecies("Modest"), 16.0);
        WorldGenBeeSpeciesCache.addWorldgenSpeciesWeight(EnumBeeSpecies.getForestrySpecies("Wintry"), 10.0);
        WorldGenBeeSpeciesCache.addWorldgenSpeciesWeight(EnumBeeSpecies.getForestrySpecies("Ended"), 0.5);
        WorldGenBeeSpeciesCache.addWorldgenSpeciesWeight(EnumBeeSpecies.MYSTICAL.getSpecies(), 20.0);
        WorldGenBeeSpeciesCache.addWorldgenSpeciesWeight(EnumBeeSpecies.UNUSUAL.getSpecies(), 20.0);
        WorldGenBeeSpeciesCache.addWorldgenSpeciesWeight(EnumBeeSpecies.SORCEROUS.getSpecies(), 13.0);
        WorldGenBeeSpeciesCache.addWorldgenSpeciesWeight(EnumBeeSpecies.ATTUNED.getSpecies(), 6.0);
        WorldGenBeeSpeciesCache.addWorldgenSpeciesWeight(EnumBeeSpecies.INFERNAL.getSpecies(), 10.0);
        WorldGenBeeSpeciesCache.addWorldgenSpeciesWeight(EnumBeeSpecies.OBLIVION.getSpecies(), 1.0);
    }
}

