/*
 * Decompiled with CFR 0.152.
 */
package magicbees.tile.logic;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import forestry.core.errors.EnumErrorCode;
import forestry.core.errors.ErrorLogic;
import javax.annotation.Nonnull;
import magicbees.tile.TileEntityEffectJar;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EffectJarHousing
implements IBeeHousing {
    private IErrorLogic errorLogic;
    private static final Iterable<IBeeListener> beeListeners = ImmutableSet.of((Object)new DefaultBeeListener());
    private static final Iterable<IBeeModifier> beeModifiers = ImmutableSet.of((Object)new JarHousingModifier());
    private final IBeekeepingLogic beekeepingLogic;
    private final TileEntityEffectJar jarEntity;
    private Biome biome;
    private final IBeeHousingInventory inventory;

    public EffectJarHousing(TileEntityEffectJar entity) {
        this.jarEntity = entity;
        this.inventory = new JarBeeHousingInventory(entity);
        this.beekeepingLogic = BeeManager.beeRoot.createBeekeepingLogic((IBeeHousing)this);
        this.errorLogic = new ErrorLogic();
    }

    public boolean canWork() {
        return this.beekeepingLogic.canWork();
    }

    @Nonnull
    public World getWorldObj() {
        return this.jarEntity.func_145831_w();
    }

    @Nonnull
    public BlockPos getCoordinates() {
        return this.jarEntity.func_174877_v();
    }

    @Nonnull
    public Biome getBiome() {
        if (this.biome == null) {
            this.biome = this.jarEntity.func_145831_w().func_180494_b(this.jarEntity.func_174877_v());
        }
        return this.biome;
    }

    @Nonnull
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome((Biome)this.getBiome(), (World)this.getWorldObj(), (BlockPos)this.getCoordinates());
    }

    @Nonnull
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue((float)this.getBiome().func_76727_i());
    }

    public int getBlockLightValue() {
        return this.getWorldObj().func_175699_k(this.getCoordinates().func_177984_a());
    }

    public boolean canBlockSeeTheSky() {
        return this.getWorldObj().func_175710_j(this.getCoordinates().func_177984_a());
    }

    public boolean isRaining() {
        return this.getWorldObj().func_175727_C(this.getCoordinates());
    }

    public GameProfile getOwner() {
        return this.jarEntity.getOwner();
    }

    @Nonnull
    public Vec3d getBeeFXCoordinates() {
        BlockPos pos = this.getCoordinates();
        return new Vec3d((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f));
    }

    @Nonnull
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Nonnull
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Nonnull
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beekeepingLogic;
    }

    @Nonnull
    public Iterable<IBeeModifier> getBeeModifiers() {
        return beeModifiers;
    }

    @Nonnull
    public Iterable<IBeeListener> getBeeListeners() {
        return beeListeners;
    }

    private static class JarHousingModifier
    implements IBeeModifier {
        private JarHousingModifier() {
        }

        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            return 0.9f;
        }

        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 0.0f;
        }

        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 0.0f;
        }

        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }

        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }

        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }

        public boolean isSealed() {
            return true;
        }

        public boolean isSelfLighted() {
            return true;
        }

        public boolean isSunlightSimulated() {
            return true;
        }

        public boolean isHellish() {
            return false;
        }
    }

    private static class JarErrorLogic
    implements IErrorLogic {
        private JarErrorLogic() {
        }

        public boolean setCondition(boolean condition, IErrorState errorState) {
            if (errorState == EnumErrorCode.NO_FLOWER) {
                System.out.println("flowers: " + !condition);
            }
            return condition;
        }

        public boolean contains(IErrorState state) {
            return false;
        }

        public boolean hasErrors() {
            return false;
        }

        public void clearErrors() {
        }

        public void writeData(PacketBuffer data) {
        }

        public void readData(PacketBuffer data) {
        }

        public ImmutableSet<IErrorState> getErrorStates() {
            return ImmutableSet.of();
        }
    }

    private static class JarBeeHousingInventory
    implements IBeeHousingInventory {
        private final TileEntityEffectJar jarEntity;

        public JarBeeHousingInventory(TileEntityEffectJar jarEntity) {
            this.jarEntity = jarEntity;
        }

        public ItemStack getQueen() {
            return this.jarEntity.getQueenStack();
        }

        public ItemStack getDrone() {
            return ItemStack.field_190927_a;
        }

        public void setQueen(ItemStack itemStack) {
            this.jarEntity.setQueenStack(itemStack);
        }

        public void setDrone(ItemStack itemstack) {
        }

        public boolean addProduct(ItemStack product, boolean all) {
            return true;
        }
    }
}

