/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.client.gui;

import com.gendeathrow.mputils.utils.RenderAssist;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ScreenNotification {
    static ArrayList<Notice> notices = new ArrayList();

    public static void ScheduleNotice(List<String> lines, String sound, int bgColorIn, int borderColorIn) {
        notices.add(new Notice(lines, sound, bgColorIn, borderColorIn));
    }

    @SubscribeEvent
    public static void onDrawScreen(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HELMET || notices.size() <= 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = new ScaledResolution(mc);
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        Notice notice = notices.get(0);
        if (!notice.init) {
            if (mc.func_147113_T() || mc.field_71462_r != null) {
                return;
            }
            notice.init = true;
            notice.startTime = Minecraft.func_71386_F();
            notice.lengthSecs = 6.0f + (float)notice.lines.size() * 0.5f;
            if (notice.sound != null) {
                mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)new SoundEvent(new ResourceLocation(notice.sound)), (float)1.0f));
            }
        }
        if (notice.getTime() >= notice.lengthSecs) {
            notices.remove(0);
            return;
        }
        GlStateManager.func_179094_E();
        float scale = width > 600 ? 1.5f : 1.0f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        width = MathHelper.func_76123_f((float)((float)width / scale));
        height = MathHelper.func_76123_f((float)((float)height / scale));
        float alpha = notice.getTime() <= notice.lengthSecs - 2.0f ? Math.min(1.0f, notice.getTime()) : Math.max(0.0f, notice.lengthSecs - 1.0f - notice.getTime());
        alpha = MathHelper.func_76131_a((float)alpha, (float)0.02f, (float)1.0f);
        float[] bgRBG = new Color(notice.bgColor).getColorComponents(null);
        float[] borderRBG = new Color(notice.borderColor).getColorComponents(null);
        int color = new Color(1.0f, 1.0f, 1.0f, alpha).getRGB();
        int shadow = new Color(0.0f, 0.0f, 0.0f, alpha).getRGB();
        Color bg = new Color(bgRBG[0], bgRBG[1], bgRBG[2], alpha * 0.9f);
        Color bg2 = new Color(borderRBG[0], borderRBG[1], borderRBG[2], alpha);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        String tmp = I18n.func_135052_a((String)notice.getLine(0), (Object[])new Object[0]);
        int txtW = mc.field_71466_p.func_78256_a(tmp);
        float scaleing = 1.5f;
        float posX = (float)width / 2.0f - (float)txtW * scaleing / 2.0f;
        float posY = (float)height / 4.0f - 8.0f;
        GuiScreen.func_73734_a((int)0, (int)((int)posY - 4), (int)width, (int)(height / 4 + 12 * notice.lines.size()), (int)bg.getRGB());
        RenderAssist.drawUnfilledRect(-5, (int)posY - 4, width + 5, height / 4 + 12 * notice.lines.size(), bg2.getRGB());
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scaleing, (float)scaleing, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        mc.field_71466_p.func_175065_a(tmp, posX / scaleing, posY / scaleing, color, false);
        GlStateManager.func_179121_F();
        for (int i = 1; i < notice.lines.size(); ++i) {
            tmp = I18n.func_135052_a((String)notice.getLine(i), (Object[])new Object[0]);
            txtW = mc.field_71466_p.func_78256_a(tmp);
            mc.field_71466_p.func_175065_a(tmp, (float)(width / 2 - txtW / 2), (float)(height / 4 + 12 * i), color, false);
        }
        GlStateManager.func_179121_F();
    }

    public static class Notice {
        long startTime = 0L;
        public float lengthSecs = 6.0f;
        public boolean init = false;
        public List<String> lines = new ArrayList<String>();
        public ItemStack icon = null;
        public String sound = null;
        public int bgColor;
        public int borderColor;

        public Notice(List<String> lines2, String sound, int bgColorIn, int borderColorIn) {
            this.startTime = Minecraft.func_71386_F();
            this.lines = lines2;
            this.sound = sound;
            this.icon = new ItemStack(Items.field_151105_aU);
            this.bgColor = bgColorIn;
            this.borderColor = borderColorIn;
        }

        public String getLine(int line) {
            if (this.validate(line)) {
                return this.lines.get(line);
            }
            return "";
        }

        private boolean validate(int line) {
            return line < this.lines.size();
        }

        public float getTime() {
            return (float)(Minecraft.func_71386_F() - this.startTime) / 1000.0f;
        }
    }
}

