/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.jei.boiler;

import java.util.List;
import mctmods.immersivetechnology.api.crafting.BoilerRecipe;
import mctmods.immersivetechnology.common.util.compat.jei.GenericMultiblockIngredient;
import mctmods.immersivetechnology.common.util.compat.jei.ITRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.JEIHelper;
import mctmods.immersivetechnology.common.util.compat.jei.boiler.BoilerRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class BoilerRecipeCategory
extends ITRecipeCategory<BoilerRecipe, BoilerRecipeWrapper> {
    public static ResourceLocation background = new ResourceLocation("immersivetech:textures/gui/gui_boiler_jei.png");
    private final IDrawable tankOverlay;

    public BoilerRecipeCategory(IGuiHelper helper) {
        super("boiler", "tile.immersivetech.metal_multiblock.boiler.name", (IDrawable)helper.createDrawable(background, 0, 77, 176, 77), BoilerRecipe.class, GenericMultiblockIngredient.BOILER);
        this.tankOverlay = helper.createDrawable(background, 177, 31, 16, 47, -2, 2, -2, 2);
    }

    public void setRecipe(IRecipeLayout recipeLayout, BoilerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(FluidStack.class);
        List outputs = ingredients.getOutputs(FluidStack.class);
        int tankSize = 0;
        for (List lists : inputs) {
            for (FluidStack fluid : lists) {
                if (fluid.amount <= tankSize) continue;
                tankSize = fluid.amount;
            }
        }
        for (List lists : outputs) {
            for (FluidStack fluid : lists) {
                if (fluid.amount <= tankSize) continue;
                tankSize = fluid.amount;
            }
        }
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        if (inputs.size() > 0) {
            guiFluidStacks.init(0, true, 100, 20, 16, 47, tankSize, false, this.tankOverlay);
            guiFluidStacks.set(0, (List)inputs.get(0));
        }
        guiFluidStacks.init(1, false, 125, 20, 16, 47, tankSize, false, this.tankOverlay);
        guiFluidStacks.set(1, (List)outputs.get(0));
        guiFluidStacks.addTooltipCallback(JEIHelper.fluidTooltipCallback);
    }

    public IRecipeWrapper getRecipeWrapper(BoilerRecipe recipe) {
        return new BoilerRecipeWrapper(recipe);
    }
}

