/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPipe;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.ITContent;
import mctmods.immersivetechnology.common.util.IPipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityFluidPipeAlternative
extends TileEntityFluidPipe
implements IPipe {
    public int transferRate = Config.ITConfig.Experimental.pipe_transfer_rate;
    public int transferRatePressurized = Config.ITConfig.Experimental.pipe_pressurized_transfer_rate;
    public static IPathingMethod pathingMethod = Config.ITConfig.Experimental.pipe_last_served ? (lastValid, outputs) -> {
        if (outputs.indexOf(lastValid) != 0) {
            Collections.swap(outputs, outputs.indexOf(lastValid), 0);
        }
    } : (lastValid, outputs) -> {
        outputs.remove(lastValid);
        outputs.add(lastValid);
    };
    private boolean busy = false;
    PipeFluidHandler[] sidedHandlers = new PipeFluidHandler[]{new PipeFluidHandler(EnumFacing.DOWN), new PipeFluidHandler(EnumFacing.UP), new PipeFluidHandler(EnumFacing.NORTH), new PipeFluidHandler(EnumFacing.SOUTH), new PipeFluidHandler(EnumFacing.WEST), new PipeFluidHandler(EnumFacing.EAST)};

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && this.sideConfig[facing.ordinal()] == 0 ? this.sidedHandlers[facing.ordinal()] : null);
    }

    public void onNeighborBlockChange(BlockPos otherPos) {
        EnumFacing dir = EnumFacing.func_176737_a((float)(otherPos.func_177958_n() - this.field_174879_c.func_177958_n()), (float)(otherPos.func_177956_o() - this.field_174879_c.func_177956_o()), (float)(otherPos.func_177952_p() - this.field_174879_c.func_177952_p()));
        if (this.updateConnectionByte(dir)) {
            ITUtils.improvedMarkBlockForUpdate(this.field_145850_b, this.field_174879_c, null, EnumSet.complementOf(EnumSet.of(dir)));
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            boolean changed = false;
            for (EnumFacing f : EnumFacing.field_82609_l) {
                if (!this.field_145850_b.func_175667_e(this.field_174879_c.func_177972_a(f))) continue;
                changed |= this.updateConnectionByte(f);
            }
            if (changed) {
                ITUtils.improvedMarkBlockForUpdate(this.field_145850_b, this.field_174879_c, null);
            }
        }
    }

    @Override
    public boolean hasCover() {
        return this.pipeCover.func_190926_b();
    }

    public void neighborPipeRemoved(EnumFacing direction) {
        for (PipeFluidHandler handler : this.sidedHandlers) {
            handler.removeFastFill(direction);
        }
    }

    @Override
    public void toggleSide(int side) {
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 0) {
            this.sideConfig[side] = -1;
        }
        this.func_70296_d();
        EnumFacing fd = EnumFacing.func_82600_a((int)side);
        TileEntity connected = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(fd));
        if (this.sideConfig[side] == 0) {
            for (PipeFluidHandler handler : this.sidedHandlers) {
                handler.enableSide(fd);
            }
        } else {
            for (PipeFluidHandler handler : this.sidedHandlers) {
                handler.disableSide(fd);
            }
        }
        if (connected instanceof TileEntityFluidPipeAlternative) {
            ((TileEntityFluidPipeAlternative)connected).sideConfig[fd.func_176734_d().ordinal()] = this.sideConfig[side];
            if (this.sideConfig[side] == 0) {
                for (PipeFluidHandler handler : ((TileEntityFluidPipeAlternative)connected).sidedHandlers) {
                    handler.enableSide(fd.func_176734_d());
                }
            } else {
                for (PipeFluidHandler handler : ((TileEntityFluidPipeAlternative)connected).sidedHandlers) {
                    handler.disableSide(fd.func_176734_d());
                }
            }
            connected.func_70296_d();
            this.field_145850_b.func_175641_c(this.func_174877_v().func_177972_a(fd), this.func_145838_q(), 0, 0);
        }
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
    }

    @Override
    public int[] getSideConfig() {
        return this.sideConfig;
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            ITUtils.improvedMarkBlockForUpdate(this.field_145850_b, this.field_174879_c, null);
            return true;
        }
        return false;
    }

    public boolean canOutputPressurized(boolean consumePower) {
        return false;
    }

    class PipeFluidHandler
    implements IFluidHandler {
        EnumFacing origin;
        ArrayList<EnumFacing> outputs = new ArrayList();
        HashMap<EnumFacing, PipeFluidHandler> fastFillOutputs = new HashMap();
        private EnumFacing lastValidDirection;

        public PipeFluidHandler(EnumFacing facing) {
            this.origin = facing;
            for (EnumFacing destination : EnumSet.complementOf(EnumSet.of(facing))) {
                if (!TileEntityFluidPipeAlternative.this.hasOutputConnection(facing)) continue;
                this.outputs.add(destination);
            }
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(null, TileEntityFluidPipeAlternative.this.transferRatePressurized, true, false)};
        }

        private int fastFill(FluidStack resource, boolean doFill) {
            if (TileEntityFluidPipeAlternative.this.busy) {
                return 0;
            }
            int remaining = resource.amount;
            this.lastValidDirection = null;
            for (EnumFacing facing : this.outputs) {
                IFluidHandler handler;
                PipeFluidHandler fastFillOutput = this.fastFillOutputs.get(facing);
                if (fastFillOutput != null) {
                    TileEntityFluidPipeAlternative.this.busy = true;
                    remaining -= fastFillOutput.fillInternal(new FluidStack(resource, remaining), doFill);
                    TileEntityFluidPipeAlternative.this.busy = false;
                    if (remaining > 0) continue;
                    this.lastValidDirection = facing;
                    return resource.amount;
                }
                TileEntity adjacentTile = Utils.getExistingTileEntity((World)TileEntityFluidPipeAlternative.this.field_145850_b, (BlockPos)TileEntityFluidPipeAlternative.this.field_174879_c.func_177972_a(facing));
                if (adjacentTile == null || (handler = (IFluidHandler)adjacentTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) == null) continue;
                TileEntityFluidPipeAlternative.this.busy = true;
                remaining -= handler.fill(Utils.copyFluidStackWithAmount((FluidStack)resource, (int)remaining, (!(handler instanceof IFluidPipe) ? 1 : 0) != 0), doFill);
                TileEntityFluidPipeAlternative.this.busy = false;
                if (handler instanceof PipeFluidHandler) {
                    this.fastFillOutputs.put(facing, (PipeFluidHandler)handler);
                }
                if (remaining > 0) continue;
                this.lastValidDirection = facing;
                return resource.amount;
            }
            return resource.amount - remaining;
        }

        private int fillInternal(FluidStack resource, boolean doFill) {
            int toReturn = this.fastFill(resource, doFill);
            if (doFill && this.lastValidDirection != null) {
                pathingMethod.DoPathing(this.lastValidDirection, this.outputs);
            }
            return toReturn;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null || resource.amount == 0) {
                return 0;
            }
            int toReturn = this.fastFill(new FluidStack(resource, Math.min(resource.amount, this.getTranferrableAmount(resource))), doFill);
            if (doFill && this.lastValidDirection != null) {
                pathingMethod.DoPathing(this.lastValidDirection, this.outputs);
            }
            return toReturn;
        }

        private int getTranferrableAmount(FluidStack resource) {
            return resource.tag != null && resource.tag.func_74764_b("pressurized") || ITContent.normallyPressurized.contains(resource.getFluid()) ? TileEntityFluidPipeAlternative.this.transferRatePressurized : TileEntityFluidPipeAlternative.this.transferRate;
        }

        public void disableSide(EnumFacing side) {
            if (this.outputs.contains(side)) {
                this.outputs.remove(side);
            }
            this.removeFastFill(side);
        }

        public void enableSide(EnumFacing side) {
            if (!this.outputs.contains(side) && side != this.origin) {
                this.outputs.add(side);
            }
        }

        public void removeFastFill(EnumFacing side) {
            this.fastFillOutputs.put(side, null);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }

    static interface IPathingMethod {
        public void DoPathing(EnumFacing var1, ArrayList<EnumFacing> var2);
    }
}

